package com.bcxin.ars.rest.util;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.service.util.ConfigUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

@Slf4j
public class ArsExceptionHandler implements HandlerExceptionResolver {
	
//	private Logger logger = Logger.getLogger(ArsExceptionHandler.class);

	@Autowired
    private ConfigUtils configUtils;

	@Override
	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {  
        if(ex instanceof UnauthorizedException){  
            ModelAndView mv = new ModelAndView("redirect:/refuse.json");  
            return mv;  
        }
        //ex.printStackTrace();
        log.error(ex.getMessage());
        
        ModelAndView mv = new ModelAndView("error");
        mv.addObject("successful", false);
        mv.addObject("code", "");

        //异常统一处理 若是表单需要验证重复提交的，返回值需要加上token
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Method method = handlerMethod.getMethod();
            if (method.isAnnotationPresent(CheckFormToken.class)) {
                CheckFormToken checkFormToken = method.getAnnotation(CheckFormToken.class);
                if (checkFormToken.required()) {
                    mv.addObject("token", configUtils.getToken());
                }
            }
        }

        if(ex instanceof ArsException){
        	mv.addObject("msg", ex.getMessage());
            mv.addObject("data", ex.toString().replaceAll("\n", "<br/>"));
        }else{
        	 mv.addObject("msg", "发生未知错误，请与系统管理员联系！");
        }

        return mv;  
    }  
	
}
