package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 合同
 * @author linqinglin
 * @date 2019/10/12 0012 17:43
 */
@Controller
@RequestMapping("comContract")
public class ComContractController {

    private Logger logger = LoggerFactory.getLogger(ComContractController.class);

    @Autowired
    private ComContractService comContractService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ArsUtil arsUtil;


    /**
     * 合同列表 页面进入
     * @param contractType
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(ComContractSearchDto searchDto,String contractType) {
        ModelAndView view = new ModelAndView();
        String page = "contract/list";
        if(Constants.CONTRACTTYPE_COMSER.equals(contractType)){
            page = page + contractType;
        }
        view.setViewName(page);
        view.addObject("contractType",contractType);
        view.addObject("record",searchDto);
        return view;
    }


    /**
     * 合同列表分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(ComContractSearchDto dto, AjaxPageResponse<ComContract> page){
        try {

            comContractService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 合同详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detail")
    public ModelAndView detail(Long id){
        ModelAndView view = new ModelAndView("contract/detail");
        try {
            view.addObject("comContract",comContractService.findById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }

    /**
     * 合同详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detailForTempTask")
    public ModelAndView detailForTempTask(Long id){
        ModelAndView view = new ModelAndView("contract/detailForTempTask");
        try {
            view.addObject("comContract",comContractService.findById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }

    /**
     * 根据人员id获取劳动合同
     * @param perId
     * @return
     */
    @RequestMapping("getContractByPerId")
    @ResponseBody
    public AjaxResult getContractByPerId(Long perId){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(comContractService.findByPerId(perId));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据人员id获取劳动合同
     * @param perId
     * @return
     */
    @RequestMapping("person/detail")
    public ModelAndView personContractDetail(Long perId){
        ModelAndView view = new ModelAndView("contract/laborContract");
        try {
            view.addObject("contractList",comContractService.findByPerId(perId));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }


    /**
     * 关联合同详情 页面进入
     * @param searchDto
     * @return
     */
    @RequestMapping("choiceContractList")
    public ModelAndView choiceContractList(ComContractSearchDto searchDto){
        ModelAndView view = new ModelAndView("contract/choiceContractList");
        User currrentUser = arsUtil.getCurrentUser();
        if(currrentUser.getPlatform() == Constants.PLATFORM_COMPANY){
            SecurityCompany company = securityCompanyService.findByUserid(currrentUser.getId());
            searchDto.setComId(Long.valueOf(company.getComId()));
        }
        view.addObject("record",searchDto);
        return view;
    }
}
