/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.SysDictDto;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.service.sys.SysDictService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import java.util.List;

/**
 * @author yangyanxin
 * @since 1.1
 */
@Controller
@RequestMapping(value = "sys/code")
public class SyscodeController {
    private Logger logger = LoggerFactory.getLogger(SyscodeController.class);
    @Autowired
    private SysDictService dictService;
    /***
     * 一次性加载编码
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/load")
    @ResponseBody
    public List load() {
        try {
            return dictService.findAll();
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    /**
     * 码表管理页面
     * @return
     */
    @RequestMapping("/toQueryPage")
    public ModelAndView toQueryPage(){
        ModelAndView view = new ModelAndView("sys/sysDict/list");
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(SysDictDto sysDictDto, AjaxPageResponse<Sysdict> page) throws Exception {
        dictService.search(sysDictDto,page);
        return page;
    }
    /**
     * 新增编辑页面
     * @param sysdict
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(Sysdict sysdict){
        ModelAndView view = new ModelAndView("sys/sysDict/edit");
        if(sysdict.getSysDictId() != null){
            Sysdict sysdict1  = dictService.findById(sysdict.getSysDictId());
            view.addObject("record",sysdict1);
        }else {
            view.addObject("record",sysdict);
        }
        return view;
    }
    /**
     * 保存
     * @param sysdict
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(Sysdict sysdict){
        AjaxResult result = new AjaxResult();
        try {
            dictService.save(sysdict);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
    /***
     * 分页加载编码
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/query")
    @ResponseBody
    public AjaxResult query() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(dictService.findAll());
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
