/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author xuerdong
 * @since 1.1
 */
@Controller
@RequestMapping(value = "/sys/area")
public class SysareaController {
	
    private Logger logger = LoggerFactory.getLogger(SysareaController.class);
    
    @Autowired
    private SysareaService areaService;

    @Autowired
    private PoliceService policeService;

    @Autowired
    private ArsRestUtil arsUtil;

    @Autowired
    private SysAreaUtil sysareaUtil;

    @Autowired
    private ConfigUtils configUtils;


    @RequestMapping("findAllForTreeView")
    public @ResponseBody AjaxResult findAllForTreeView(SysareaSearchDTO sysareaSearchDTO) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Police police=null;
            if(user!=null){
                police= policeService.findById(user.getOrgid());
            }

            if(sysareaSearchDTO.getOrgid() ==null){
                sysareaSearchDTO.setOrgid(user.getOrgid());
            }
            if(police!=null){
                sysareaSearchDTO.setCode(police.getAreacode());
            }
            List<TreeView> list = areaService.searchForTreeView(sysareaSearchDTO);
            result.setData(list);
            result.setSuccessful(true);
        } catch(Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("findByOrgIdForTreeView")
    public @ResponseBody AjaxResult findByOrgIdForTreeView(Long orgid) throws Exception {
    	AjaxResult result = new AjaxResult();
    	try {
    	    if(orgid!=null) {
                Police police = policeService.findById(orgid);
                if(police!=null) {
                    List<TreeView> list = areaService.findTreeViewByCode(police.getAreacode());result.setData(list);
                }
            }
    		result.setSuccessful(true);
    	} catch(Exception e) {
    		throw e;
    	}
    	return result;
    }


    /**
     * 查询区域，遍历省市区
     * @param sysareaSearchDTO
     * @return
     * @throws Exception
     * @author Liaoyufei
     * @date 2018/05/18
     */
    @RequestMapping("searchForCompany")
    public @ResponseBody AjaxResult searchForCompany(SysareaSearchDTO sysareaSearchDTO) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user!=null){
                if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
                    //显示北京全市的
                    sysareaSearchDTO.setOrgtype("1");
                    sysareaSearchDTO.setProvinceCode(configUtils.getCurrentNative() + "____");
                }else{
                    Police police= user.getPolice();
                    sysareaSearchDTO.setUserid(user.getId());
                    if(police!=null){
                        String areaCode =police.getAreacode();
                        if (StringUtil.isNotEmpty(areaCode)) {

                            if (areaCode.endsWith("0000")) {
                                sysareaSearchDTO.setOrgtype("1");
                                sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "____");

                            } else if (areaCode.endsWith("00")) {
                                //市、设置机构类型 市级2
                                sysareaSearchDTO.setOrgtype("2");
                                sysareaSearchDTO.setCityCode(areaCode.substring(0, 4) + "__");
                                sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "0000");
                            }else{
                                //区、设置机构类型 区3
                                sysareaSearchDTO.setOrgtype("3");
                                sysareaSearchDTO.setCityCode(areaCode.substring(0, 4) + "00");
                                sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "0000");
                                sysareaSearchDTO.setDistrictCode(areaCode);
                            }
                        }
                    }
                    sysareaSearchDTO.setPath(user.getPolice().getPath());
                }

                //直接查询出所有区域后，再根据nodeid和parentid进行遍历
                SysareaSearchDTO data = areaService.searchAll(sysareaSearchDTO);
                List<Sysarea> list = data.getData();
                if(list != null && list.size() >0){
                List<Sysarea> listtop = new ArrayList<Sysarea>();
                for(Sysarea temp: list ){
                    List<Sysarea> childrens = new ArrayList<Sysarea>();
                    for (Sysarea temp1: list ){
                        if(temp1.getParentid() != null && temp.getNodeid().equals(temp1.getParentid())){
                            childrens.add(temp1);
                        }
                    }
                    temp.setNodes(childrens);
                    listtop.add(temp);
                }

                result.setSuccessful(true);
                    List<Sysarea> list1 = new ArrayList<Sysarea>();
                    //获取list中陕西省部分，添加到list1；
                    list1.add(list.get(0));
                    result.setData(list1);
                }

            }else{
            	throw new ArsException("用户信息错误！");
            }

        } catch(Exception e) {
            throw e;
        }
        return result;
    }



    @RequestMapping("searchSimpleTreeView")
    public @ResponseBody AjaxResult searchSimpleTreeView(SysareaSearchDTO sysareaSearchDTO) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user!=null){
                Police police= policeService.findById(user.getOrgid());
                if(police!=null && StringUtil.isEmpty(sysareaSearchDTO.getParentid())){
                    sysareaSearchDTO.setCode(police.getAreacode());
                }
                List<TreeView> list = areaService.searchSimpleTreeView(sysareaSearchDTO);
                if(list != null && list.size() > 0 && StringUtil.isEmpty(sysareaSearchDTO.getParentid())){
                    sysareaSearchDTO.setCode(null);
                    for (TreeView treeView : list){
                        sysareaSearchDTO.setParentid(treeView.getNodeid());
                        treeView.setNodes(areaService.searchSimpleTreeView(sysareaSearchDTO));
                    }
                }
                result.setData(list);
                result.setSuccessful(true);
            }else{
            	throw new ArsException("用户信息错误！");
            }

        } catch(Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("findByParentId")
    public @ResponseBody AjaxResult findByParentId(Long parentid) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
        	List<Sysarea> sysareaList = areaService.findByParentId(parentid);
            result.setData(sysareaList);
            result.setSuccessful(true);
        } catch(Exception e) {
            throw e;
        }
        return result;
    }
    
    @RequestMapping("findCurrentAreaList")
    public @ResponseBody AjaxResult findCurrentAreaList(SysareaSearchDTO sysareaSearchDTO) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
        	List<Sysarea> sysareaList = areaService.findCurrentAreaList(sysareaSearchDTO);
            result.setData(sysareaList);
            result.setSuccessful(true);
        } catch(Exception e) {
            throw e;
        }
        return result;
    }
    
    @RequestMapping("findByCode")
    public @ResponseBody AjaxResult findByCode(String code) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
        	Sysarea sysarea = areaService.findByCode(code);
        	if(sysarea != null){
	            result.setData(sysarea);
	            result.setSuccessful(true);
        	}else{
        		result.setSuccessful(false);
        	}
        } catch(Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * 获取省份
     * @return
     */
    @RequestMapping(value = "/provinceList")
    public @ResponseBody Collection<TreeView> provinceList(){
        return sysareaUtil.provinceMap();
    }

    /**
     * 获取地区
     * 支持根据省查市，根据市查区县
     * @return
     */
    @RequestMapping(value = "/getRegionByParent")
    public @ResponseBody
    Collection<TreeView> regionList(HttpServletRequest request){
        String parentId = request.getParameter("parentId");
        Collection<TreeView> regionList = sysareaUtil.cityMap(parentId);
        if (regionList == null || regionList.size() == 0) {
            regionList = sysareaUtil.areaMap(parentId);
        }
        return regionList;
    }


    /**
     * 查询全部 for easyui的 comboTree
     * @return
     */
    @RequestMapping("getAreaTrees")
    public @ResponseBody List<Tree> getAreaTrees(SysareaSearchDTO sysareaSearchDTO) throws Exception{
        List<Tree> trees = new ArrayList<Tree>();
        try {
            User user = arsUtil.getCurrentUser();
            if(user!=null){
//                if("1".equals(sysareaSearchDTO.getRankAuth())){
//                    sysareaSearchDTO.setShowAll("1");
//                }
                if(StringUtil.isEmpty(sysareaSearchDTO.getShowAll())) {
//                    if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
//                        //显示北京全市的
//                        sysareaSearchDTO.setOrgtype("1");
//                        sysareaSearchDTO.setProvinceCode(configUtils.getCurrentNative() + "____");
//                    } else {
                        Police police = user.getPolice();
                        sysareaSearchDTO.setUserid(user.getId());
                        if (police != null) {
                            String areaCode = police.getAreacode();
                            if (StringUtil.isNotEmpty(areaCode)) {

                                if (areaCode.endsWith("0000")) {
                                    sysareaSearchDTO.setOrgtype("1");
                                    sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "____");

                                } else if (areaCode.endsWith("00")) {
                                    //市、设置机构类型 市级2
                                    sysareaSearchDTO.setOrgtype("2");
                                    sysareaSearchDTO.setCityCode(areaCode.substring(0, 4) + "__");
                                    sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "0000");
                                } else {
                                    //区、设置机构类型 区3
                                    sysareaSearchDTO.setOrgtype("3");
                                    sysareaSearchDTO.setCityCode(areaCode.substring(0, 4) + "00");
                                    sysareaSearchDTO.setProvinceCode(areaCode.substring(0, 2) + "0000");
                                    sysareaSearchDTO.setDistrictCode(areaCode);
                                }
                            }
                        }
                        sysareaSearchDTO.setPath(user.getPolice().getPath());
//                    }
                }

                //直接查询出所有区域后，再根据nodeid和parentid进行遍历
                SysareaSearchDTO data = areaService.searchAll(sysareaSearchDTO);
                List<Sysarea> list = data.getData();
                if(list != null && list.size() >0){
                    List<Sysarea> listtop = new ArrayList<Sysarea>();
                    for(Sysarea temp: list ){
                        List<Sysarea> childrens = new ArrayList<Sysarea>();
                        for (Sysarea temp1: list ){
                            if(temp1.getParentid() != null && temp.getNodeid().equals(temp1.getParentid())){
                                childrens.add(temp1);
                            }
                        }
                        temp.setNodes(childrens);
                        listtop.add(temp);
                    }
                    for (Sysarea sysarea1:
                        listtop ) {
                        if(StringUtil.isEmpty(sysarea1.getParentid())) {
                            Tree tree = new Tree();
                            if(StringUtil.isEmpty(sysareaSearchDTO.getShowAll())) {
                                tree.setExpanded(true);
                                tree.setState("open");
                            }
                            tree.setText(sysarea1.getText());
                            tree.setId(sysarea1.getCode());
                            List<Tree> childrens = new ArrayList<Tree>();
                            for (Sysarea sysarea : sysarea1.getNodes()) {
                                childrens.add(getTreeFormArea(sysarea, true));
                                tree.setChildren(childrens);
                            }
                            trees.add(tree);
                        }
                    }
                }

            }else{
                throw new ArsException("用户信息错误！");
            }

        } catch(Exception e) {
            throw e;
        }
        return trees;
    }


    /**
     * 查询全部 for easyui的 comboTree
     * @return
     */
    @RequestMapping("searchForTree")
    public @ResponseBody List<Tree> searchForTree(SysareaSearchDTO dto) throws Exception{
        return areaService.searchForTree(dto);
    }

    private Tree getTreeFormArea(Sysarea sysarea,Boolean expanded){
        Tree tree = new Tree();
        tree.setId(sysarea.getCode());
        tree.setText(sysarea.getText());
        if(expanded){
            tree.setState("open");
        }
        if(sysarea.getNodes() != null && sysarea.getNodes().size() > 0){
            List<Tree> childTrees = new ArrayList<Tree>();
            for(Sysarea childArea:sysarea.getNodes()){
                childTrees.add(getTreeFormArea(childArea,expanded));
            }
            tree.setChildren(childTrees);
        }
        return tree;
    }

    /**
     * 查询全部 for layui的 selectTree
     * @return
     */
    @RequestMapping("searchForLayTree")
    public @ResponseBody List<LayTree> getOrgTreesForLay(SysareaSearchDTO searchDto) throws Exception {
        return areaService.searchForLayTree(searchDto);
    }
}
