package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.SubsidyConfigDto;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.service.sys.SubsidyConfigService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RequestMapping(value = "sys/subsidyConfig")
public class SubsidyConfigController {
    private Logger logger = LoggerFactory.getLogger(SubsidyConfigController.class);
    @Autowired
    private SubsidyConfigService subsidyConfigService;

    /**
     * 补贴参数配置页面
     * @return
     */
    @RequestMapping("/toQueryPage")
    public ModelAndView toQueryPage(){
        ModelAndView view = new ModelAndView("sys/subsidyConfig/list");
        return view;
    }
    /**
     * 新增编辑页面
     * @param subsidyConfig
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(SubsidyConfig subsidyConfig){
        ModelAndView view = new ModelAndView("sys/subsidyConfig/edit");
        if(subsidyConfig.getId() != null){
            SubsidyConfig subsidyConfig1 = subsidyConfigService.findById(subsidyConfig.getId());
            view.addObject("record",subsidyConfig1);
        }else {
            view.addObject("record",subsidyConfig);
        }
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(SubsidyConfigDto subsidyConfigDto, AjaxPageResponse<SubsidyConfig> page) throws Exception {
        subsidyConfigService.search(subsidyConfigDto,page);
        return page;
    }
    /**
     * 保存
     * @param subsidyConfig
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(SubsidyConfig subsidyConfig){
        AjaxResult result = new AjaxResult();
        try {
            subsidyConfigService.save(subsidyConfig);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}
