package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.SubsidyComparisonDto;
import com.bcxin.ars.model.sys.SubsidyComparison;
import com.bcxin.ars.service.sys.SubsidyComparisonService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @author  yyx
 * @date 2020-05-18
 */
@Controller
@RequestMapping(value = "sys/subsidyComparison")
public class SubsidyComparisonController {
    private Logger logger = LoggerFactory.getLogger(SubsidyComparisonController.class);
    @Autowired
    private SubsidyComparisonService subsidyComparisonService;

    /**
     * 补贴参数配置页面
     * @return
     */
    @RequestMapping("/toQueryPage")
    public ModelAndView toQueryPage(){
        ModelAndView view = new ModelAndView("sys/subsidyComparison/list");
        return view;
    }
    /**
     * 新增编辑页面
     * @param subsidyComparison
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView editIndex(SubsidyComparison subsidyComparison){
        ModelAndView view = new ModelAndView("sys/subsidyComparison/edit");
        if(subsidyComparison.getId() != null){
            SubsidyComparison subsidyComparison1 = subsidyComparisonService.findById(subsidyComparison.getId());
            view.addObject("record",subsidyComparison1);
        }else {
            view.addObject("record",subsidyComparison);
        }
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(SubsidyComparisonDto subsidyComparisonDto, AjaxPageResponse<SubsidyComparison> page) throws Exception {
        subsidyComparisonService.search(subsidyComparisonDto,page);
        return page;
    }
    /**
     * 保存
     * @param subsidyComparison
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(SubsidyComparison subsidyComparison){
        AjaxResult result = new AjaxResult();
        try {
            subsidyComparisonService.save(subsidyComparison);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}
