package com.bcxin.ars.rest.sys;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.page.ModuleMenuPageSearchDto;
import com.bcxin.ars.dto.sys.MenuDto;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

/**
 * 功能权限表控制器
 *
 * @author linqinglin
 * @Date 2020-03-27 14:35:21
 */
@Controller
@RequestMapping("moduleMenu")
public class ModuleMenuController {

    Logger logger = LoggerFactory.getLogger(ModuleMenuController.class);

    @Autowired
    ModuleMenuService moduleMenuService;

    @Autowired
    ConfigUtils configUtils;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("sys/moduleMenu/list");
        return view;
    }
    /**
     * 广西内网菜单列表
     * @return
     */
    @RequestMapping("gxList/index")
    public ModelAndView gxList(){
        ModelAndView view = new ModelAndView("sys/moduleMenu/gxList");
        return view;
    }

    /**
     * 查看页面
     * @param moduleMenu
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(ModuleMenu moduleMenu){
        ModelAndView view = new ModelAndView("sys/moduleMenu/detail");

        if(moduleMenu.getId() != null){
            view.addObject("record",moduleMenuService.findById(moduleMenu.getId()));
        }else {
            view.addObject("record", moduleMenu);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param moduleMenu
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(ModuleMenu moduleMenu){
        ModelAndView view = new ModelAndView("sys/moduleMenu/edit");

        if(moduleMenu.getId() != null){
            view.addObject("record",moduleMenuService.findById(moduleMenu.getId()));
        }else {
            view.addObject("record", moduleMenu);
        }
        view.addObject("token",configUtils.getToken());

        return view;
    }

    /**
     * 保存
     * @param moduleMenu
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(ModuleMenu moduleMenu){
        AjaxResult result = new AjaxResult();
        try {
            moduleMenuService.save(moduleMenu);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
    /**
     * 保存
     * @param moduleMenu
     * @return
     */
    @RequestMapping("updateSeq")
    @ResponseBody
    public AjaxResult updateSeq(ModuleMenu moduleMenu){
        AjaxResult result = new AjaxResult();
        try {
            moduleMenuService.updateSeq(moduleMenu);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
    /**
     * 禁用
     * @param moduleMenu
     * @return
     */
    @RequestMapping("delete")
    @ResponseBody
    public AjaxResult delete(ModuleMenu moduleMenu){
        AjaxResult result = new AjaxResult();
        try {
            moduleMenuService.delete(moduleMenu);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
    /**
     * 启用
     * @param moduleMenu
     * @return
     */
    @RequestMapping("enable")
    @ResponseBody
    public AjaxResult enable(ModuleMenu moduleMenu){
        AjaxResult result = new AjaxResult();
        try {
            moduleMenuService.enable(moduleMenu);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(ModuleMenuPageSearchDto dto, AjaxPageResponse<ModuleMenu> page){
        moduleMenuService.searchForPage(dto,page);
        return page;
    }

    /**
     * 树形列表查询
     * @param dto
     * @return
     */
    @RequestMapping("searchForTree")
    @ResponseBody
    public List<ModuleMenu> searchForTree(ModuleMenuPageSearchDto dto, AjaxPageResponse<ModuleMenu> page){
        return moduleMenuService.searchForTree(dto,page);
    }

    @RequestMapping("findMenuTreeForPermission")
    @ResponseBody
    public List<MenuTree> findMenuTreeForPermission(Long roleId){
        return moduleMenuService.findMenuTreeForPermission(roleId);
    }

    @RequestMapping("findForLayTree")
    @ResponseBody
    public List<LayTree> findForLayTree(){
        return moduleMenuService.findForLayTree();
    }

    /**
     * 旧菜单权限补全
     * @param moduleMenu
     * @return
     */
    @RequestMapping("useOld")
    @ResponseBody
    public AjaxResult useOld(ModuleMenu moduleMenu){
        AjaxResult result = new AjaxResult();
        try {
            moduleMenuService.useOld(moduleMenu);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }


    /**
     * 树形列表查询
     * @return
     */
    @RequestMapping("searchForGXTree")
    @ResponseBody
    public List<MenuDto> searchForGXTree(){
        return moduleMenuService.searchForGXTree();
    }
}

