package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.page.LoginLogPageSearchDto;
import com.bcxin.ars.model.LoginLog;
import com.bcxin.ars.service.LoginLogService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 登录记录Controller
 * 
 * @author lin
 * @date 2021-03-30
 */
@Controller
@RequestMapping("/loginLog")
public class LoginLogController{
    Logger logger = LoggerFactory.getLogger(LoginLogController.class);

    @Autowired
    private LoginLogService loginLogService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    public ModelAndView listIndex(LoginLogPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("sys/loginLog/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(LoginLogPageSearchDto dto, AjaxPageResponse<LoginLog> page){
        loginLogService.searchForPage(dto,page);
        return page;
    }

}
