package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.ExportConfigDto;
import com.bcxin.ars.dto.sys.SubsidyConfigDto;
import com.bcxin.ars.model.sys.ExportConfig;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.service.sys.ExportConfigService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/***
 * 通用配置导出
 */
@Controller
@RequestMapping("sys/exportConfig")
public class ExportConfigController {
    /***
     * 日志
     */
    private static  final Logger logger = LoggerFactory.getLogger(ExportConfigController.class);
    @Autowired
    private ExportConfigService exportConfigService;
    /**
     *
   * @return
     */
    @RequestMapping("list")
    public ModelAndView list() {
        ModelAndView view = new ModelAndView("sys/exportConfig/list");
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(ExportConfigDto exportConfigDto, AjaxPageResponse<ExportConfig> page) throws Exception {
        exportConfigService.search(exportConfigDto,page);
        return page;
    }
    /**
     * 新增编辑页面
     * @param exportConfig
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView editIndex(ExportConfig exportConfig){
        ModelAndView view = new ModelAndView("sys/exportConfig/edit");
        view.addObject("record",exportConfig);
        return view;
    }
    /**
     * 进入修改页面
     * @return
     */
    @RequestMapping("enterEditPage")
    public ModelAndView enterEditPage(Long id) {
        ModelAndView view = new ModelAndView("sys/exportConfig/edit");
        view.addObject("record",   exportConfigService.findById(id));
        return view;
    }
    /**
     * 保存
     * @param exportConfig
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ExportConfig exportConfig){
        AjaxResult result = new AjaxResult();
        try {
            exportConfigService.save(exportConfig);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }


}
