package com.bcxin.ars.rest.sys;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.page.ApprovalOutTimePageSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.sys.ApprovalFormDto;
import com.bcxin.ars.dto.sys.DSApprovalDto;
import com.bcxin.ars.enums.FileType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.approve.ReplyRar;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.act.ActivitiCommentService;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.statistics.PoliceNoticeStatisticsService;
import com.bcxin.ars.service.sys.ApprovalLogService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.ReplyRarService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/***
 * @author hsen
 * 待办事项
 */
@Controller
@RequestMapping("approval")
public class ApprovalController {
    /***
     * 日志
     */
    private static  final  Logger logger = LoggerFactory.getLogger(ApprovalController.class);
    /**
     * 待办事项service层
     */
    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private  FamilyService familyService;

    @Autowired
    private  PersonworkexperienceService personworkexperienceService;
    @Autowired
    private ApprovalLogService approvalLogService;
    @Autowired
    private FilerecordService filerecordService;

    @Autowired
    private FilerecordStatusService filerecordStatusService;
    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private ArsRestUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DatasyncService datasyncService;

    @Autowired
    private ActivitiCommentService activitiCommentService;

    @Autowired
    private SubsidiaryService subsidiaryService;
    @Autowired
    private YearreportdataService yearreportdataService;

    @Autowired
    private PersoncertificateService personcertificateService;
    @Autowired
    private ReplyRarService replyRarService;
    @Autowired
    private UserService userService;

    @Autowired
    private PoliceNoticeStatisticsService policeNoticeStatisticsService;

    @Autowired
    private BusinessService businessService;

    @Autowired
    private PoliceService policeService;

    @Autowired
    private SponsorlicenseService sponsorlicenseService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Value("${upload-folder}")
    private String uploadFolder;

    @Value("${approval-download-folder}")
    private String downloadFolder;

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${temp-folder}")
    private String tempfolder;

    @Value("${AppraiseURL}")
    private String AppraiseURL;

    /**
     * 查询审批信息
     *
     * @param dto
     * @return
     */
    @RequestMapping("query")
    public @ResponseBody
    AjaxResult query(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //截止日期查询往后一天  比如截止到2017-06-23等同于<=2017-06-23,但在mysql查询中等价于<=2017-06-24
            Calendar calendar = new GregorianCalendar();
            if (null != dto.getEndDate() && !"".equals(dto.getEndDate())) {
                calendar.setTime(dto.getEndDate());
                calendar.add(Calendar.DATE, 1);
                dto.setEndDate(calendar.getTime());
            }
            ApprovalDTO data = approvalService.query(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    @RequestMapping("/searchApprovalList_table")
    @ResponseBody
    @RequiresPermissions("todoList:query")
    public PageResult searchApprovalList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                               HttpServletRequest req, HttpServletResponse resp) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);

        return approvalService.searchApprovalList_table(p);
    }

    @RequestMapping("/searchApprovalForPage")
    @ResponseBody
    @RequiresPermissions("todoList:query")
    public PageResult searchApprovalForPage(@RequestParam Map<Object, Object> params, HttpServletRequest req) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        return approvalService.searchApprovalForPage(p);
    }
    /***
     * 统计审批超时3天
     * @return
     * @throws Exception
     */
    @RequestMapping("countTimeOutDays")
    public @ResponseBody AjaxResult countTimeOutDays() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setData(approvalService.countTimeOutDays());
            result.setSuccessful(true);
            return result;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }

    /**
     * 公安 未读消息统计
     * 主要统计：
     * 待审批数量
     * 指纹待录入
     * 未缴费确认
     * 待批复数量-保安公司
     * 待上传数量-保安公司
     * 待制证数量-保安公司
     * 待批复数量-培训单位
     * 待上传数量-培训单位
     * 待制证数量-培训单位
     * 待打印数量-保安员证
     *
     * @param params
     * @param req
     * @return
     */
    @RequestMapping("/policeNotice")
    @ResponseBody
    public AjaxResult policeNotice(@RequestParam Map<Object, Object> params, HttpServletRequest req) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        //处长角色id
        p.put("czjsid",req.getServletContext().getAttribute("czjsid"));
        //打印的保安员证角色id
        req.getServletContext().getAttribute("printPersonCardRole");
        AjaxResult result = new AjaxResult();
        result.setData(policeNoticeStatisticsService.getPoliceNotice(p));
        result.setSuccessful(true);
        return result;
    }


    /**
     * 公安 未读消息统计
     * 主要统计：
     * 待审批数量
     * 指纹待录入
     * 未缴费确认
     * 待批复数量-保安公司
     * 待上传数量-保安公司
     * 待制证数量-保安公司
     * 待批复数量-培训单位
     * 待上传数量-培训单位
     * 待制证数量-培训单位
     * 待打印数量-保安员证
     *
     * @param params
     * @param req
     * @return
     */
    @RequestMapping("/dashboard")
    public ModelAndView dashboard(@RequestParam Map<Object, Object> params, HttpServletRequest req) {
        ModelAndView view = new ModelAndView("dashboard");
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        //处长角色id
        p.put("czjsid",req.getServletContext().getAttribute("czjsid"));
        p.put("searchType","001");
        //打印的保安员证角色id
        req.getServletContext().getAttribute("printPersonCardRole");
        view.addObject("content",policeNoticeStatisticsService.getPoliceNotice(p));
        return view;
    }


    /****
     * 进入超时未处理事项
     * @return
     */
    @RequestMapping("/toOutTimePage")
    @RequiresPermissions("approvalOutTimeList:query")
    public ModelAndView toOutTimePage(ApprovalOutTimePageSearchDto dto) {
        ModelAndView view = new ModelAndView("approveOutTime/list");
        view.addObject("record",dto);
        return view;
    }
    /***
     * 查询超时未审批记录
     * @param dto 查询条件参数
     * @param page 返回数据对象
     * @return 查询列表
     */
    @RequestMapping("searchForOutTimeApproval")
    @RequiresPermissions("approvalOutTimeList:query")
    public @ResponseBody  AjaxPageResponse searchForOutTimeApproval(ApprovalOutTimePageSearchDto dto, AjaxPageResponse page){
        try {
            approvalService.searchForOutTimeApproval(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    @RequestMapping("/approvalTable")
    @ResponseBody
    public Object queryTable(@RequestParam Map<Object, Object> params, ModelMap model,
                             HttpServletRequest req, HttpServletResponse resp) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);


        User user = arsUtil.getCurrentUser();

        String areacode = "";
        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            areacode = p.get("areaCode").toString();
        } else {
            if ("1".equals(user.getPlatform().toString())) {
                areacode = user.getPolice().getAreacode();
            }
        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {
                //省
                p.put("areaCode", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                //市
                p.put("areaCode", areacode.substring(0, 4) + "__");
            } else {
                p.put("areaCode", areacode);
            }
        }
        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());

        String allCount = String.valueOf(approvalService.queryAllCnt(p));
        String weekNewAddCount = String.valueOf(approvalService.queryWeekNewAddCnt(p));
        String monthsNewAddCount = String.valueOf(approvalService.queryMonthsNewAddCnt(p));
        String yearNewAddCount = String.valueOf(approvalService.queryYearNewAddCnt(p));

        JSONObject json = new JSONObject();
        json.put("allCount", allCount);
        json.put("weekNewAddCount", weekNewAddCount);
        json.put("monthsNewAddCount", monthsNewAddCount);
        json.put("yearNewAddCount", yearNewAddCount);
        return json;
    }

    @RequestMapping("/approvalList_table")
    @ResponseBody
    public PageResult query(@RequestParam Map<Object, Object> params, ModelMap model,
                        HttpServletRequest req, HttpServletResponse resp) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        User user = arsUtil.getCurrentUser();
        String areacode = "";
        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            areacode = p.get("areaCode").toString();
        } else {
            if ("1".equals(user.getPlatform().toString())) {
                areacode = user.getPolice().getAreacode();
            }
        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {
                //省
                p.put("areaCode", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                //市
                p.put("areaCode", areacode.substring(0, 4) + "__");
            } else {
                p.put("areaCode", areacode);
            }
        }

        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());
        //进行查询，并转换
        return approvalService.queryApprovalList(p);
    }

    /**
     * @Author: wangcy
     * @Description:查询待审批的条数
     * @Date: 2018/03/07 0007 17:21
     */
    @RequestMapping("findApprovalNumble")
    public @ResponseBody
    AjaxResult findApprovalNumble(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            approvalService.findApprovalNumble(dto);
            result.setData("99");
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 保存审核状态
     * @param dto
     * @return
     */
    @RequestMapping("saveReply")
    public @ResponseBody
    AjaxResult saveReply(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {

            approvalService.saveReply(dto);
            Approval approval = approvalService.findById(dto.getId());
            result.setSuccessful(true);
            result.setData(approval);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 保存审核状态
     * @param dto
     * @return
     */
    @RequestMapping("saveBQ")
    public @ResponseBody
    AjaxResult saveBQ(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            approvalService.saveBQ(dto);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 保存审核状态
     * @param dto
     * @return
     */
    @RequestMapping("saveApproval")
    public @ResponseBody
    @RequiresPermissions("todoList:approval")
    AjaxResult saveApproval(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            approvalService.saveApproval(dto);
            result.setData(approvalService.findById(dto.getId()));
            result.setSuccessful(true);
        } catch (Exception e) {

            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 批量保存审核状态
     * @param personIds
     * @return
     */
    @RequestMapping("batchSaveApproval")
    public @ResponseBody
    AjaxResult batchSaveApproval(Long[] personIds) throws Exception {
        try {
            //先查询可以进行保安员资格证审批的人
            return approvalService.batchSaveApproval(personIds);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }
    /***
     * 保存批复文件
     * @param replyRar
     * @return
     */
    @RequestMapping("saveReplyRar")
    public @ResponseBody
    @RequiresPermissions("sponsorlicense:uploadfile")
    AjaxResult saveReplyRar(ReplyRar replyRar) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            replyRar.setCreateBy(user.getRealname());
            replyRar.setCreateTime(new Date());
            replyRar.setActive(true);
            replyRarService.saveReplyRar(replyRar);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 删除批复文件
     * @param id
     * @return
     */
    @RequestMapping("deleteReplyRar")
    public @ResponseBody
    AjaxResult deleteReplyRar(Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            replyRarService.deleteById(id);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 查询批复文件List
     * @param
     * @return
     */
    @RequestMapping("findReplyRarList")
    public @ResponseBody
    PageResult findReplyRarList(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {

            //查询初始化
            Map<Object, Object> p = CTLUtil.init(req, params);
            //进行查询，并转换
            return replyRarService.findByBusinessIDAndType(p);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    /***
     * 保存对外意见
     * @param dto
     * @return
     */
    @RequestMapping("saveApprovalOutreason")
    public @ResponseBody
    AjaxResult saveApprovalOutreason(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            approvalService.saveApprovalOutreason(dto);
            result.setData(approvalService.findById(dto.getId()));
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 根据ID获取审批信息
     * @param id
     * @return
     */
    @RequestMapping("queryById")
    public @ResponseBody
    AjaxResult queryById(Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setData(approvalService.queryById(id));
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 根据业务类型和业务ID查询
     * @param dto
     * @return
     */
    @RequestMapping("getBusinessidAndType")
    public @ResponseBody
    AjaxResult getBusinessidAndType(ApprovalDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();

            result.setData(approvalService.getBusinessidAndType(dto));
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导出审批信息-生成excel
     *
     * @param dto
     * @param request
     */
    @RequestMapping("createApprovalsExcel")
    @Deprecated
    public @ResponseBody
    AjaxResult createApprovalsExcel(ApprovalDTO dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {

                List<Approval> data = approvalService.findAll();

                if (data != null) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_审批列表.xls");
                    //判断是否是IE11
                    Boolean flag = request.getHeader("User-Agent").indexOf("like Gecko") > 0;
                    if (request.getHeader("User-Agent").toLowerCase().indexOf("msie") > 0 || flag) {
                        //IE浏览器
                        templateName = URLEncoder.encode(templateName, "UTF-8");
                    } else {
                        //先去掉文件名称中的空格,然后转换编码格式为utf-8,保证不出现乱码,这个文件名称用于浏览器的下载框中自动显示的文件名
                        templateName = new String(templateName.replaceAll(" ", "").getBytes("UTF-8"), "ISO8859-1");
                    }
                    File file = new File(templateName);
                    approvalService.exportApprovals(data, file);

                    result.setData(templateName);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出审批信息
     *
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportApprovals")
    public void exportApprovals(String templateName, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            File file = new File(templateName);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
                file.delete();
            }
        }
    }

    /**
     * 批量导入审批列表（仅适用与内网数据导入到外网）
     */
   /* @RequestMapping("importApprovalData")
    @Deprecated
    public @ResponseBody
    AjaxResult importApprovalData(MultipartFile file, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行审批文件上传..." + targetFile);
            file.transferTo(targetFile);

            Map<String, Object> resultMap = approvalService.importApproval(targetFile);
            result.setData(resultMap);
            if (resultMap.get("faildFilePath") == null || StringUtil.isEmpty(resultMap.get("faildFilePath").toString())) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg("导入失败，请下载失败列表，修改后再上传.");
            }
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }*/


    /**
     * 批量导入审批列表（仅适用与内网数据导入到外网）
     */
    @RequestMapping("importData")
    @Deprecated
    public @ResponseBody
    AjaxResult importData(MultipartFile file, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            if (!file.getOriginalFilename().startsWith("approval")) {
                throw new ArsException("导入失败，非待办事项的数据！");
            }

            Map<String, String> pathMap = new HashMap<>();
            List<String> filePaths = new ArrayList<String>();
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行文件上传..." + targetFile);
            file.transferTo(targetFile);
            File dataFile = null;
            long startTime = System.currentTimeMillis();
            try {
                //输入源zip路径
                ZipInputStream Zin = new ZipInputStream(new FileInputStream(targetFile));
                BufferedInputStream Bin = new BufferedInputStream(Zin);
                //输出路径（文件夹目录）
                String Parent = tempfolder;
                File Fout = null;
                ZipEntry entry;
                try {
                    while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
                        Fout = new File(Parent, entry.getName());
                        if (!Fout.exists()) {
                            (new File(Fout.getParent())).mkdirs();
                        }
                        FileOutputStream out = new FileOutputStream(Fout);
                        BufferedOutputStream Bout = new BufferedOutputStream(out);
                        int b;
                        while ((b = Bin.read()) != -1) {
                            Bout.write(b);
                        }
                        Bout.close();
                        out.close();
                        if (Fout.getName().endsWith(".data")) {
                            dataFile = Fout;
                        } else {
                            pathMap.put(Fout.getName(), Fout.getPath());
                        }
                        filePaths.add(Fout.getPath());
                        logger.info(Fout + "解压成功");
                    }
                    Bin.close();
                    Zin.close();
                } catch (IOException e) {
                    logger.info(e.getMessage());
                }
            } catch (FileNotFoundException e) {
                logger.info(e.getMessage());
            }
            long endTime = System.currentTimeMillis();
            targetFile.delete();
            logger.info("耗费时间： " + (endTime - startTime) + " ms");
            if (dataFile != null) {
                BufferedReader br = new BufferedReader(new FileReader(dataFile));
                StringBuffer content = new StringBuffer();
                // 获取文件内容
                String lineTxt = null;
                while ((lineTxt = br.readLine()) != null) {
                    // 使用readLine方法，一次读一行
                    content.append(lineTxt);
                }
                br.close();

                String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

                DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);

                if (dataSycDto != null) {
                    if (Constants.DATASYC_APPROVAL_LIST.equals(dataSycDto.getDataType())) {
                        DSApprovalDto approvalDto = JSONObject.parseObject(dataSycDto.getData(), DSApprovalDto.class);


                        //create by zjh time：2018年8月15日 14:16:22  如果日志列表不为空
                        if (null != approvalDto.getApprovalLogList() && approvalDto.getApprovalLogList().size() > 0) {
                            //create by zjh time：2018年8月15日 14:16:22 批量插入日志
                            approvalLogService.importBatchLog(approvalDto.getApprovalLogList());
                        }

                        //2018年9月14日15:46:16 wjb 同步文件记录 导到外网
                        if (null != approvalDto.getFilerecordList() && approvalDto.getFilerecordList().size() > 0) {
                            filerecordService.importBatchFilerecord(approvalDto.getFilerecordList());
                            //     filerecordStatusService.importBatchFilerecordStatus(approvalDto.getFilerecordList());

                        }

                        if (null != approvalDto.getApprovalList() && approvalDto.getApprovalList().size() > 0) {
                            List<Approval> approvalList = approvalDto.getApprovalList();
                            //批量导入方法 createBy zjh time:2018年8月17日 17:27:12
                            approvalService.batchImportApproval(approvalList, pathMap);
                        }

                        result.setMsg("导入成功");
                        result.setSuccessful(true);
                    } else {
                        result.setMsg("导入失败，非待办事项的数据！");
                        result.setSuccessful(false);
                    }
                } else {
                    result.setMsg("导入失败，非待办事项的数据！");
                    result.setSuccessful(false);
                }
            } else {
                result.setMsg("导入失败，非待办事项的数据！");
                result.setSuccessful(false);
            }
            for (String filePath : filePaths) {
                FileUtil.deleteFolder(filePath);
            }

            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("faildFilePath", "");
            result.setData(resultMap);
        } catch (BadPaddingException badPaddingException) {
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导出审批列表（仅适用与内网数据导入到外网）
     */
    @RequestMapping("exportData")
    @Deprecated
    public @ResponseBody
    AjaxResult exportData() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                DataSycDto dataSycDto = new DataSycDto();
                DSApprovalDto approvalDto = new DSApprovalDto();
                dataSycDto.setDataType(Constants.DATASYC_APPROVAL_LIST);
                List<String> filePaths = new ArrayList<String>();
                //找到导出标志为true的审批，防止重复导出
                List<Approval> approvalList = approvalService.searchUpdateflagForExport();
                //List<Approval> approvalList = approvalService.findAll();
                //List<ActivitiComment> commentList = activitiCommentService.findAll();

                for (Approval approval : approvalList) {
                    if (StringUtil.isNotEmpty(approval.getInfoRar())) {
                        filePaths.add(baseFolder + approval.getInfoRar().replace("getResource.do?path=", ""));
                    }
                    if (StringUtil.isNotEmpty(approval.getReplyRar())) {
                        filePaths.add(baseFolder + approval.getReplyRar().replace("getResource.do?path=", ""));
                    }
                    if (StringUtil.isNotEmpty(approval.getOutinfoRar())) {
                        filePaths.add(baseFolder + approval.getOutinfoRar().replace("getResource.do?path=", ""));
                    }
                    if (StringUtil.isNotEmpty(approval.getConfirmPath())) {
                        filePaths.add(baseFolder + approval.getConfirmPath().replace("getResource.do?path=", ""));
                    }
                    if (StringUtil.isNotEmpty(approval.getRegisterPath())) {
                        filePaths.add(baseFolder + approval.getRegisterPath().replace("getResource.do?path=", ""));
                    }

                    //申请备案通过后，相关信息，同步显示在分公司管理。--向公安申请备案通过之后，由公安导出到外网时，审批通过的，并把信息同步生成到分公司管理
                    if ("003".equals(approval.getBusinessid()) && "003".equals(approval.getApprovalstate())) {
                        Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
                        SbSubsidiaryBase sbSubsidiaryBase = new SbSubsidiaryBase();
                        sbSubsidiaryBase.setCompanyName(subsidiary.getCompanyname());
                        sbSubsidiaryBase.setRegisterAddress(subsidiary.getAddress());
                        sbSubsidiaryBase.setMoneyPrincipal(subsidiary.getChargename());
                        sbSubsidiaryBase.setMoneyPrincipalId(subsidiary.getChargecardnumber());
                        sbSubsidiaryBase.setMoneyPrincipalPhone(subsidiary.getChargephone());

                        subsidiaryService.saveOrUpdate(subsidiary);

                    }
                }
                //modify zjh time:2018年8月14日 15:32:01 添加审批日志
                List<ApprovalLog> approvalLogList = approvalLogService.findApprovalLogByTime(DateUtil.getCurrentDate("yyyy-MM-dd"), DateUtil.getDateStrAfterToday(2));
                approvalDto.setApprovalLogList(approvalLogList);
                approvalDto.setApprovalList(approvalList);

                //2018年9月19日13:47:02  添加同步记录到外网
                List<Filerecord> filerecordList = filerecordService.findFilerecordByTime(DateUtil.getDateStrAfterToday(-2), DateUtil.getTomorrow());
                approvalDto.setFilerecordList(filerecordList);


                dataSycDto.setData(JSONObject.toJSONString(approvalDto));
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(tempfolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String listStr = JSONObject.toJSONString(dataSycDto);
                String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));

                String filepath = FileUtil.writeTxtFile(content, "approval", tempfolder);

                if (StringUtil.isNotEmpty(filepath)) {
                    filePaths.add(filepath);
                    result.setData(FileUtil.zipFiles(filePaths, tempfolder + FileUtil.generatingFileNameByDate("approval") + ".zip"));
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 判断是否流程结束
     *
     * @return
     */
    @RequestMapping("checkProcess")
    public @ResponseBody
    AjaxResult checkProcess(Long approvalId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(approvalService.checkProcess(approvalId));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("showConfirmForm")
    public ModelAndView showConfirmForm(Long approvalId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("apply/confirmForm");

        ApprovalFormDto formDto = approvalService.findFormDataByApprovalId(approvalId);
        view.addObject("content", formDto);
        return view;
    }

    @RequestMapping("showRegisterForm")
    public ModelAndView showRegisterForm(Long approvalId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("apply/registerForm");
        ApprovalFormDto formDto = approvalService.findFormDataByApprovalId(approvalId);
        view.addObject("content", formDto);

        return view;
    }


//    @RequestMapping("test")
//    @ResponseBody
//    public String test(){
//
//        Approval a1=new Approval();
//        a1.setBusinesstype("005");
//        a1.setApprovalstate("003");
//        a1.setBusinessid(16L);
//
//        Approval a2=new Approval();
//        a2.setBusinesstype("006");
//        a2.setApprovalstate("003");
//        a2.setBusinessid(77L);
//
//        Approval a3=new Approval();
//        a3.setBusinesstype("010");
//        a3.setApprovalstate("003");
//        a3.setBusinessid(26L);
//
//        List<Approval> list=new ArrayList<>();
//        list.add(a1);
//        list.add(a2);
//        list.add(a3);
//
//        for(Approval l : list){
//            //审批通过才需要发送短信
//            if(l.getApprovalstate().equals(ApprovalState.SHTG)) {
//                //启用线程异步发送
//                new Thread(() -> {
//                    try {
//                        approvalService.sendMsg(l);
//                    } catch (Exception e) {
//                        e.printStackTrace();
//                    }
//                }).start();
//            }
//        }
//        return "ok";
//
//    }


    /**
     * 手动重新生成登录单，确认单
     *
     * @param approvalId
     * @return
     */
    @RequestMapping("manualCreateForm")
    public @ResponseBody
    AjaxResult manualCreateForm(Long approvalId) {

        AjaxResult result = new AjaxResult();

        Approval approval = approvalService.findById(approvalId);

        if (StringUtil.isNotEmpty(approval.getRegisterPath())) {
            approvalService.manualCreateConfirmAndRegisterForm(approval);
        }
        return result;
    }


    @RequestMapping("approveMenu")
    public ModelAndView approveMenu(String butype) {
        ModelAndView view = new ModelAndView("approval/approveMenu");
        User currentUser = arsUtil.getCurrentUser();
        view.addObject("company", securityCompanyService.findByUserid(currentUser.getId()));
        view.addObject("butype",butype);
        return view;
    }

    /**
     *
     * @param fileType 文件类型 RECEIPT回执单 、NOTICE通知书
     * @return
     */
    @RequestMapping("upload/init")
    public ModelAndView uploadInit(FileType fileType, Long approvalId){
        ModelAndView view = new ModelAndView("approval/uploadApprovalFile");
        view.addObject("fileType",fileType);
        view.addObject("approvalId",approvalId);
        return view;
    }

    /**
     * 保存回执单 、通知书的路径
     * @param fileType
     * @param approvalId
     * @param filePath
     * @return
     * @throws Exception
     */
    @RequestMapping("saveUpload")
    @Deprecated
    public @ResponseBody
    AjaxResult saveUpload(FileType fileType,Long approvalId,String filePath) throws Exception {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        Approval approval = approvalService.findById(approvalId);

        if (StringUtil.isNotEmpty(filePath)) {
            approval.setOutinfoRar(filePath);
            approvalService.update(approval);
        }
        return result;
    }

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(ApprovalPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("/approval/list");
        view.addObject("record",searchDto);
        return view;
    }
    @RequestMapping("approvalDetail/{businessType}")
    public ModelAndView approvalDetail(@PathVariable String businessType,Long businessId){
        ModelAndView view = new ModelAndView("/approval/approval"+businessType);
        Approval approval = approvalService.findBybusinessidAndType(businessId,businessType);
        view.addObject("approval",approval);
        view.addObject("record",businessService.findByBusinessTypeAndId(businessType,businessId));
        view.addObject("lastProcess",approvalService.checkProcess(approval.getId()));
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(ApprovalPageSearchDto dto, AjaxPageResponse<Approval> page){
        arsUtil.setPoliceSearch(dto);
        dto.setUserid(arsUtil.getCurrentUser().getId());
        approvalService.searchForPage(dto,page);
        return page;
    }


    /**
     * 保安服务公司许可(审批进度)打印
     * @param processInstanceId
     * @return
     * @throws Exception
     */
    @RequestMapping("getApprovalLog/{processInstanceId}")
    @ResponseBody
    public AjaxResult getApprovalLog(@PathVariable("processInstanceId")Long processInstanceId) throws Exception{
        AjaxResult result = new AjaxResult();
        if (processInstanceId == null) {
            return null;
        }
        try {
            List<ApprovalLog> logList = approvalLogService.findByProcessInstanceId(processInstanceId.toString());
            result.setSuccessful(true);
            result.setData(logList);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("businessDetail")
    public ModelAndView businessDetail( String approvalId) throws Exception {
        ModelAndView view = new ModelAndView();

        try {
            approvalId = DES3.decode(approvalId);
        }catch (Exception e){

        }
        Approval approval = approvalService.findById(Long.parseLong(approvalId));

//        BusinessCommon businessCommon = businessService.findByBusinessTypeAndId(approval.getBusinesstype(),approval.getBusinessid());

//        if(businessCommon.getOrgid()!=null){
//            businessCommon.setPolice(policeService.findById(businessCommon.getOrgid()));
//        }
        view.addObject("detail",approval);

        switch (approval.getBusinesstype()){
            case BusinessType.BAFWGS:
                view.setViewName("jdcx/approvalBAF");
                break;
            case BusinessType.PXDW:
                view.setViewName("jdcx/approvalPXDW");
                break;
            case BusinessType.BAYZ:
                view.setViewName("jdcx/approvalCpyBAYZ");
                break;
            case BusinessType.BAGSZGS:
                view.setViewName("jdcx/approvalZGS");
                break;
            case BusinessType.KQYBAGS:
                view.setViewName("jdcx/approvalKJ");
                break;
            case BusinessType.ZXZY:
                view.setViewName("jdcx/approvalZZ");
                break;
            default:
                break;
        }
        return view;
    }

    @RequestMapping("/appraise")
    public String appraise(String serviceCode,String feedBackId, RedirectAttributes attr) {
        attr.addAttribute("serviceCode", serviceCode);
        attr.addAttribute("source", AppraiseConstants.source);
        attr.addAttribute("token", generate(configUtils.bj_zrr_client_secret+AppraiseConstants.source));
        attr.addAttribute("userProp", "1");

        if(StringUtil.isNotEmpty(feedBackId)){
            attr.addAttribute("feedBackId", feedBackId);
        }
        return "redirect:"+AppraiseURL+AppraiseConstants.URL_APPRAISE4PC_PRE;
    }


    /***
     * 登记备案号
     * @param approval
     * @return
     */
    @RequestMapping("editRecordNo")
    public @ResponseBody
    AjaxResult editRecordNo(Approval approval) throws Exception {
        try {
            return approvalService.editRecordNo(approval);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }

    public static String generate(String msg) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(16);
        sb.append(r.nextInt(99999999)).append(r.nextInt(99999999));
        int len = sb.length();
        if (len < 16) {
            for (int i = 0; i < 16 - len; i++) {
                sb.append("0");
            }
        }
        String salt = sb.toString();
        msg = md5Hex(msg + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            cs[i] = msg.charAt(i / 3 * 2);
            char c = salt.charAt(i / 3);
            cs[i + 1] = c;
            cs[i + 2] = msg.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }
    private static String md5Hex(String src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bs = md5.digest(src.getBytes());
            return new String(new Hex().encode(bs));
        } catch (Exception e) {
            return null;
        } }
}
