package com.bcxin.ars.rest.sxzw;

import com.bcxin.ars.dto.SxsSbAjaxResult;
import com.bcxin.ars.dto.SxsZwAjaxResult;
import com.bcxin.ars.service.sxzw.SxZwWebService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 陕西省互联网+公安政务服务接口
 * 
 * @author zhangye
 * @version 1.0
 */
@Controller
@RequestMapping("sxzwweb")
public class SxZwWebController {

	private static final Logger logger = LoggerFactory.getLogger(SxZwWebController.class);

	@Autowired
	private SxZwWebService sxZwWebService;

	/**
	 * @Author: zhangye
	 * @Description:提供给公安政务单点接口 1、公安政务第一次访问单点登陆接口，调用公安政务token校验接口，检验成功则返回url，url增加重定向(redirectUrl)方法
	 *                          2、公安政务获取返回url，重定向跳转同样接口，用户登陆，重定向redirectUrl的地址
	 * @param token
	 *            令牌
	 * @param itemId
	 *            办理事项ID
	 * @param redirectUrl
	 *            访问URL
	 * @return
	 * @throws Exception
	 * 
	 */
	@RequestMapping("/xas/autoLogin")
	public @ResponseBody SxsZwAjaxResult autoLogin(String token, String itemId, String redirectUrl,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletContext servletContext = request.getServletContext();
		String rootPath = servletContext.getContextPath();
		SxsZwAjaxResult sxsZwAjaxResult = new SxsZwAjaxResult();
		try {
			if (StringUtil.isEmpty(token)) {
				sxsZwAjaxResult.setMsg("token不能为空");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}
			String url = "";// 返回给公安政务请求URL
			if (StringUtil.isEmpty(redirectUrl)) {
				String apiUrl = "http://" + request.getServerName() + ":" + request.getServerPort()
						+ request.getRequestURI();
				url = apiUrl + "?token=" + token + "&redirectUrl=" + "index.do";
			}
			logger.info(token);
			sxsZwAjaxResult = sxZwWebService.login(token, itemId, url, redirectUrl, request);
			if (!StringUtil.isEmpty(redirectUrl)) {
				if (sxsZwAjaxResult.getCode() == Constants.SXS_XAS_CODE_SUCCES) {
					response.sendRedirect(rootPath + "/" + redirectUrl);
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return sxsZwAjaxResult;
	}



	/**
	 * @Author: zhangye
	 * @Description:提供给公安政务单点接口 1、公安政务第一次访问单点登陆接口，调用公安政务token校验接口，检验成功则返回url，url增加重定向(redirectUrl)方法
	 *                          2、公安政务获取返回url，重定向跳转同样接口，用户登陆，重定向redirectUrl的地址
	 * @param appId
	 *            接入系统ID
	 * @param timeStamp
	 *            时间戳
	 * @param randomStr
	 *            随机字符串
	 * @param signStr
	 *            签名字符串
	 * @return
	 * @throws Exception
	 *
	 */
	@RequestMapping("/xas/query")
	public @ResponseBody
	SxsSbAjaxResult query(String appId, String timeStamp, String randomStr, String signStr) throws Exception {
		SxsSbAjaxResult sxsZwAjaxResult = new SxsSbAjaxResult();
		try {
			if (StringUtil.isEmpty(appId)) {
				sxsZwAjaxResult.setMsg("appId不能为空");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}
			if (StringUtil.isEmpty(timeStamp)) {
				sxsZwAjaxResult.setMsg("timeStamp不能为空");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}
			if (StringUtil.isEmpty(randomStr)) {
				sxsZwAjaxResult.setMsg("randomStr不能为空");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}
			if (StringUtil.isEmpty(signStr)) {
				sxsZwAjaxResult.setMsg("signStr不能为空");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}

			sxsZwAjaxResult = sxZwWebService.query(appId, timeStamp, randomStr, signStr);
			sxsZwAjaxResult.setAppName("陕西省保安服务监管信息系统");

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return sxsZwAjaxResult;
	}
}
