package com.bcxin.ars.rest.sx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sx.AuthUserInfo;
import com.bcxin.ars.service.sx.AuthorizeService;
import com.bcxin.ars.service.util.ConfigUtils;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping("sxzwfw")
public class sxzwfwController {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeController.class);
    //在浏览器地址输入运行结果后台打印：http://61.185.238.223/sysauthserver/authorizeTest
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private AuthorizeService authorizeService;
    /**
     * 获得令牌
     * @return oauth_callback?code=1234
     */
    @RequestMapping(value = "/handle" ,method = RequestMethod.GET)
    public String handle(HttpServletRequest request, Model model, HttpServletResponse response,String business,String accessToken) throws OAuthProblemException {
        ServletContext servletContext = request.getServletContext();
        String rootPath = servletContext.getContextPath();
        try {
                OAuthClient oAuthClient = new OAuthClient(new URLConnectionClient());
                OAuthClientRequest userInfoRequest = new OAuthBearerClientRequest(configUtils.authurl+"/sysauthserver/userInfo")
                        .setAccessToken(accessToken)
                        .buildQueryMessage();
                //请求用户信息
                OAuthResourceResponse resourceResponse = oAuthClient.resource(userInfoRequest, OAuth.HttpMethod.GET, OAuthResourceResponse.class);
                String userInfo = resourceResponse.getBody();
                logger.info("获得登录用户信息 userInfo="+userInfo);
                AuthUserInfo authUserInfo = JSONObject.parseObject(userInfo, AuthUserInfo.class);
                AjaxResult ajaxResult = authorizeService.login(authUserInfo.getLoginUser(), request);
                if (ajaxResult.isSuccessful()) {
                    return "redirect:/index.do";
                }else{
                    response.sendRedirect(rootPath+"/login.jsp");
                }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return "redirect:/index.do";
    }
}

