package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.PersonAwardDto;
import com.bcxin.ars.dto.page.supervision.PersonAwardPageSearchDto;
import com.bcxin.ars.model.supervision.PersonAward;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.PersonAwardService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 人员表彰奖励
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("personAward")
public class PersonAwardController {

    Logger logger = LoggerFactory.getLogger(PersonAwardController.class);

    @Autowired
    PersonAwardService personAwardService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(PersonAwardPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/personAward/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param personAward
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(PersonAward personAward){
        ModelAndView view = new ModelAndView("supervision/personAward/edit");

        if(personAward.getId() != null){
            view.addObject("record",personAwardService.findById(personAward.getId()));
        }else {
            personAward.setDataSource(Constants.CHECKTYPE_PC);
            view.addObject("record", personAward);
        }

        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(personAward.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param personAward
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(PersonAward personAward){
        AjaxResult result = new AjaxResult();
        try {
            personAwardService.save(personAward);
            result.setData(personAward.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonAwardPageSearchDto dto, AjaxPageResponse<PersonAwardDto> page){
        personAwardService.searchForPage(dto,page);
        return page;
    }
}
