package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.OtherPunishPageSearchDto;
import com.bcxin.ars.model.supervision.OtherPunish;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.OtherPunishService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 其他违法违规处罚
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("otherPunish")
public class OtherPunishController {

    Logger logger = LoggerFactory.getLogger(OtherPunishController.class);

    @Autowired
    OtherPunishService otherPunishService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @param searchDto
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(OtherPunishPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/otherPunish/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param otherPunish
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(OtherPunish otherPunish){
        ModelAndView view = new ModelAndView("supervision/otherPunish/edit");

        if(otherPunish.getId() != null){
            view.addObject("record",otherPunishService.findById(otherPunish.getId()));
        }else {
            otherPunish.setPunishType(Constants.PUNISHTYPE_PERSON);
            view.addObject("record", otherPunish);
        }

        view.addObject("token",configUtils.getToken());
        return view;
    }

    /**
     * 保存
     * @param otherPunish
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(OtherPunish otherPunish){
        AjaxResult result = new AjaxResult();
        try {
            otherPunishService.save(otherPunish);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(OtherPunishPageSearchDto dto, AjaxPageResponse<OtherPunish> page){
        otherPunishService.searchForPage(dto,page);
        return page;
    }
}
