package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.CompanyPunishDto;
import com.bcxin.ars.dto.page.supervision.CompanyPunishPageSearchDto;
import com.bcxin.ars.model.supervision.CompanyPunish;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.CompanyPunishService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 公司违法违规处罚
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("companyPunish")
public class CompanyPunishController {

    Logger logger = LoggerFactory.getLogger(CompanyPunishController.class);

    @Autowired
    CompanyPunishService companyPunishService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @param searchDto
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CompanyPunishPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/companyPunish/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param companyPunish
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(CompanyPunish companyPunish,String institutionTypeName){
        ModelAndView view = new ModelAndView("supervision/companyPunish/edit");

        if(companyPunish.getId() != null){
            CompanyPunish record = companyPunishService.findById(companyPunish.getId());
            //未驻入系统的时候要给未驻入系统的公司名赋值
            if(!StringUtils.isEmpty(record.getIsInSystem()) && record.getIsInSystem().equals(Constants.NOT_IN_SYS)){
                record.setCompanyNameDefine(record.getCompanyName());
            }
            view.addObject("record",record);
        }else {
            //新增是默认为pc端录入，默认是系统已入驻
            companyPunish.setDataSource(Constants.CHECKTYPE_PC);
            companyPunish.setIsInSystem(Constants.IS_IN_SYS);
            view.addObject("record", companyPunish);
        }
        view.addObject("institutionTypeName", institutionTypeName);

        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(companyPunish.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param companyPunish
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(CompanyPunish companyPunish){
        AjaxResult result = new AjaxResult();
        try {
            companyPunishService.save(companyPunish);
            result.setData(companyPunish.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CompanyPunishPageSearchDto dto, AjaxPageResponse<CompanyPunishDto> page){
        companyPunishService.searchForPage(dto,page);
        return page;
    }
}
