package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.CompanyAwardDto;
import com.bcxin.ars.dto.page.supervision.CompanyAwardPageSearchDto;
import com.bcxin.ars.model.supervision.CompanyAward;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.CompanyAwardService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 公司表彰奖励
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("companyAward")
public class CompanyAwardController {

    Logger logger = LoggerFactory.getLogger(CompanyAwardController.class);

    @Autowired
    CompanyAwardService companyAwardService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;

    /**
     * 管理列表页面
     * @param searchDto
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CompanyAwardPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/companyAward/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param companyAward
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(CompanyAward companyAward,String institutionTypeName){
        ModelAndView view = new ModelAndView("supervision/companyAward/edit");

        if(companyAward.getId() != null){
            CompanyAward record = companyAwardService.findById(companyAward.getId());
            //未驻入系统的时候要给未驻入系统的公司名赋值
            if(!StringUtils.isEmpty(record.getIsInSystem()) && record.getIsInSystem().equals(Constants.NOT_IN_SYS)){
                record.setCompanyNameDefine(record.getCompanyName());
            }
            view.addObject("record",record);
        }else {
            //新增是默认为pc端录入，默认是系统已入驻
            companyAward.setDataSource(Constants.CHECKTYPE_PC);
            companyAward.setIsInSystem(Constants.IS_IN_SYS);
            view.addObject("record", companyAward);
        }
        view.addObject("token",configUtils.getToken());
        view.addObject("institutionTypeName", institutionTypeName);
        view.addObject("companyList", companyService.findByAll(companyAward.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param companyAward
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(CompanyAward companyAward){
        AjaxResult result = new AjaxResult();
        try {
            companyAwardService.save(companyAward);
            result.setData(companyAward.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CompanyAwardPageSearchDto dto, AjaxPageResponse<CompanyAwardDto> page){
        companyAwardService.searchForPage(dto,page);
        return page;
    }
}
