package com.bcxin.ars.rest.subsidy;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.TrainSubsidyConfigPageSearchDto;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.subsidy.TrainSubsidyConfigService;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 培训单位补贴简称批次配置控制器
 *
 * @author linqinglin
 * @Date 2020-05-27 10:30:45
 */
@Controller
@RequestMapping("trainSubsidyConfig")
public class TrainSubsidyConfigController {

    Logger logger = LoggerFactory.getLogger(TrainSubsidyConfigController.class);

    @Autowired
    TrainSubsidyConfigService trainSubsidyConfigService;

    @Autowired
    SecurityCompanyService securityCompanyService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("subsidy/train/list");
        return view;
    }

    /**
     * 查看页面
     * @param trainSubsidyConfig
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(TrainSubsidyConfig trainSubsidyConfig){
        ModelAndView view = new ModelAndView("subsidy/train/detail");

        if(trainSubsidyConfig.getId() != null){
            view.addObject("record",trainSubsidyConfigService.findById(trainSubsidyConfig.getId()));
        }else {
            view.addObject("record", trainSubsidyConfig);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param trainSubsidyConfig
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(TrainSubsidyConfig trainSubsidyConfig){
        ModelAndView view = new ModelAndView("subsidy/train/edit");

        if(trainSubsidyConfig.getId() != null){
            view.addObject("record",trainSubsidyConfigService.findById(trainSubsidyConfig.getId()));
        }else {
            view.addObject("record", trainSubsidyConfig);
        }
        view.addObject("companyList", securityCompanyService.findByAll(Constants.INSTITUTIONTYPE_PXDW));
        return view;
    }

    /**
     * 保存
     * @param trainSubsidyConfig
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(TrainSubsidyConfig trainSubsidyConfig){
        AjaxResult result = new AjaxResult();
        try {
            trainSubsidyConfigService.save(trainSubsidyConfig);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(TrainSubsidyConfigPageSearchDto dto, AjaxPageResponse<TrainSubsidyConfig> page){
        trainSubsidyConfigService.searchForPage(dto,page);
        return page;
    }
}

