package com.bcxin.ars.rest.subsidy;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.dto.subsidy.SubsidyOfflinePageSearchDto;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.bcxin.ars.service.subsidy.SubsidyOfflineService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 线下补贴审批单Controller
 * 
 * @author lin
 * @date 2020-11-12
 */
@Controller
@RequestMapping("/subsidyOffline")
public class SubsidyOfflineController{
    Logger logger = LoggerFactory.getLogger(SubsidyOfflineController.class);

    @Autowired
    private SubsidyOfflineService subsidyOfflineService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("subsidyOffline:view")
    public ModelAndView listIndex(SubsidyOfflinePageSearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidyOffline/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
      * 批次列表页面
      * @return
      */
    @RequestMapping("batchList/index")
    public ModelAndView batchList(GradeSubsidyBatchPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidyOffline/batchList");
        view.addObject("record", searchDto);
        return view;
    }


    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("approve/index")
    public ModelAndView approveIndex(SubsidyOffline subsidyOffline){
        ModelAndView view = new ModelAndView("subsidyOffline/approve");
        view.addObject("record", subsidyOffline);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("subsidyOffline:view")
    public AjaxPageResponse searchForPage(SubsidyOfflinePageSearchDto dto, AjaxPageResponse<SubsidyOffline> page){
        subsidyOfflineService.searchForPage(dto,page);
        return page;
    }

    /**
     * 生成线下资金审批单
     * @param batchIds
     * @return
     */
    @RequestMapping("create")
    @ResponseBody
    public AjaxResult create(Long[] batchIds){
        AjaxResult result = new AjaxResult();
        try {
            subsidyOfflineService.create(batchIds);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 撤销
     * @param subsidyOffline
     * @return
     */
    @RequestMapping("revoke")
    @ResponseBody
    public AjaxResult revoke(SubsidyOffline subsidyOffline){
        AjaxResult result = new AjaxResult();
        try {
            subsidyOfflineService.revoke(subsidyOffline);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 更新审批状态
     * @param subsidyOffline
     * @return
     */
    @RequestMapping("approve")
    @ResponseBody
    public AjaxResult approve(SubsidyOffline subsidyOffline){
        AjaxResult result = new AjaxResult();
        try {
            subsidyOfflineService.approve(subsidyOffline);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
