package com.bcxin.ars.rest.subsidy;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.QRCodeUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("gradeSubsidyRoster")
public class GradeSubsidyRosterController {
    private Logger logger = LoggerFactory.getLogger(GradeSubsidyRosterController.class);

    @Autowired
    private GradeSubsidyRosterService gradeSubsidyRosterService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${temp-folder}")
    private String tempFolder;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private GradeCompleteCerService gradeCompleteCerService;

    @Autowired
    private PersonGradeService personGradeService;

    /**
     * 等级证对比人员名单
     * @return
     */
    @RequestMapping("/toQueryPage")
    @RequiresPermissions("gradeSubsidyList:query")
    public ModelAndView toQueryPage(GradeSubsidyRosterSearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidy/grade/list");
        view.addObject("record",searchDto);
        return view;
    }


    @RequestMapping("publicityIsReturn/index")
    public ModelAndView publicityIsReturn(GradeSubsidyRosterSearchDto searchDto){

        ModelAndView view = new ModelAndView("subsidy/grade/publictity");
        view.addObject("record",searchDto);
        return  view;
    }



    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("trainList/index")
    public ModelAndView trainListIndex(GradeSubsidyRosterSearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidy/grade/trainList");
        User currentUser = arsUtil.getCurrentUser();
        if(Constants.PLATFORM_COMPANY == currentUser.getPlatform()) {
            SecurityCompany company = securityCompanyService.findByUserid(currentUser.getId());
            view.addObject("company", company);
        }
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("applyList/index")
    public ModelAndView applyListIndex(GradeSubsidyRosterSearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidy/grade/applyList");
        User currentUser = arsUtil.getCurrentUser();
        if(Constants.PLATFORM_COMPANY == currentUser.getPlatform()) {
            SecurityCompany company = securityCompanyService.findByUserid(currentUser.getId());
            view.addObject("company", company);
        }
        view.addObject("record",searchDto);
        return view;
    }
    /**
     * 查看页面
     * @param gradeSubsidyRoster
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(GradeSubsidyRoster gradeSubsidyRoster) throws Exception {
        ModelAndView view = new ModelAndView("subsidy/grade/detail");
        gradeSubsidyRoster = gradeSubsidyRosterService.findById(gradeSubsidyRoster.getId());
        if(Constants.SUBSIDYCERTYPE_DJZ.equals(gradeSubsidyRoster.getSubsidyCerType())) {
            try {
                PersonGrade personGrade = personGradeService.findById(gradeSubsidyRoster.getGradeId());
                GradeCompleteCer gradeCompleteCer = gradeCompleteCerService.findByIdNum(personGrade.getIdNum(), personGrade.getGradeLevel());
                gradeSubsidyRoster.setCerId(gradeCompleteCer.getId());
                String bbdUrl = gradeCompleteCerService.getBbdH5Url(String.valueOf(gradeCompleteCer.getId()));
                String pathName = QRCodeUtil.generateBase64QRCode(bbdUrl, 100, 100, "jpg");
                gradeSubsidyRoster.setQrcode(pathName);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        view.addObject("record",gradeSubsidyRoster);
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRoster> page) throws Exception {
        arsUtil.setPoliceSearch(searchDto);
        gradeSubsidyRosterService.search(searchDto,page);
        return page;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("searchForApply")
    @ResponseBody
    public AjaxPageResponse searchForApply(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRosterDto> page) throws Exception {
        arsUtil.setPoliceSearch(searchDto);
        gradeSubsidyRosterService.searchForApply(searchDto,page);
        return page;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("statistics")
    @ResponseBody
    public AjaxResult statistics(GradeSubsidyRosterSearchDto searchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            arsUtil.setPoliceSearch(searchDto);
            result.setData(gradeSubsidyRosterService.statistics(searchDto));
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
    /**
     * 保存
     * @param gradeSubsidyRoster
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(GradeSubsidyRoster gradeSubsidyRoster){
        AjaxResult result = new AjaxResult();
        try {
            gradeSubsidyRosterService.save(gradeSubsidyRoster);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 选择补贴人员
     * @return
     */
    @RequestMapping("choicePerson")
    public ModelAndView choicePerson(GradeSubsidyRosterSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/choicePerson");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 批次关联补贴人员
     * @return
     */
    @RequestMapping("batchPerson")
    public ModelAndView batchPerson(GradeSubsidyRosterSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/personList");
        view.addObject("record", searchDto);
        return view;
    }

}
