package com.bcxin.ars.rest.statistics;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.EchartMapData;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.statistics.SecurityStatisticsService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 业务情况统计（保安员，保安公司）
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Controller
@RequestMapping("statistics/security")
public class SecurityStatisticsController {

	Logger logger = LoggerFactory.getLogger(SecurityStatisticsController.class);
	
	@Autowired
	private SecurityStatisticsService securityService;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private SysAreaUtil sysAreaUtil;

	@Autowired
	private SecurityStatisticsService securityStatisticsService;

	@Autowired
	private SecurityCompanyService companyService;
	/**
	 * 限制area选择
	 * @return
	 */
	@RequestMapping("areaLimit")
	public @ResponseBody AjaxResult areaLimit(){
		String areaCode = arsUtil.getCurrentUser().getPolice().getAreacode();
		if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
			areaCode = Constants.BEIJING +"0000";
		}
		TreeView region = sysAreaUtil.getRegionByCode(areaCode);
		AjaxResult result = new AjaxResult();
		result.setSuccessful(true);
		result.setData(region);
		return result;
	}


	@RequestMapping("/companyTable")
	@ResponseBody
	public Object queryTable(@RequestParam Map<Object, Object> params, HttpServletRequest req) {
		Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

		String areaCode = p.get("areaCode").toString();
		User user = arsUtil.getCurrentUser();
		// 修改公司总数、已初始化、未初始化 BUG by llc 2018-08-02
		if (StringUtil.isEmpty(areaCode)) {
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING;
			}else{
				p.put("userid", user.getId());
				p.put("path", user.getPolice().getPath());
				areaCode = user.getPolice().getAreacode();
			}
		}
		if(areaCode.endsWith("0000")){  // 省
			areaCode =  areaCode.substring(0,2);
		}else if(areaCode.endsWith("00")){ // 市
			areaCode =  areaCode.substring(0,4);
		}
		p.put("areaCode",areaCode);
		Map map = companyService.queryCompanyStatistics(p);
		return JSONObject.toJSONString(map);
	}

	@RequestMapping("/companyList_table")
	@ResponseBody
	public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
		Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
		ParamDTO paramDTO = BeanUtil.mapToBean(p,ParamDTO.class,true);
		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				paramDTO.setAreaCode(Constants.BEIJING +"0000");
			}else{
				paramDTO.setAreaCode(arsUtil.getCurrentUser().getPolice().getAreacode());
			}
		}

		PageResult pageResult = securityStatisticsService.companyDetail(paramDTO);
		CTLUtil.out(pageResult, resp);//进行查询，并转换
		return null ;
	}

	/**
	 * 保安员分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityPerson")
	public @ResponseBody AjaxResult securityPerson() throws Exception{
		AjaxResult result = new AjaxResult();
		return result;
	}

	/**
	 * 保安公司分析，汇总数据
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityCompanySummary")
	public @ResponseBody AjaxResult securityCompanySummary(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}

		Map map = securityService.securityCompanySummary(paramDTO);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}

	/**
	 * 保安公司分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityCompany")
	public @ResponseBody AjaxResult securityCompany(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		PageResultDTO resultDTO = securityService.securityCompanyDetail(paramDTO);;
		result.setSuccessful(true);
		result.setData(resultDTO);
		return result;
	}

	/**
	 * 保安公司区域分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityCompanyArea")
	public @ResponseBody AjaxResult securityCompanyArea(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		List<Map> mapList = securityService.securityCompanyArea(paramDTO);
		List<EchartMapData> mapDataList = Lists.newArrayList();
		for (Map map:mapList) {
			EchartMapData data = new EchartMapData();
			data.setName(map.get("name").toString());
			data.setValue(Integer.parseInt(map.get("dws").toString()));
			mapDataList.add(data);
		}
		result.setSuccessful(true);
		result.setData(mapDataList);
		return result;
	}


	/**
	 * 保安员汇总
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityPersonSummary")
	public @ResponseBody AjaxResult securityPersonSummary(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		Map map = securityService.securityPersonSummary(paramDTO);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}

	/**
	 * 新增及离职分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("securityPersonDetail")
	public @ResponseBody AjaxResult securityCompanyDetail(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		PageResultDTO resultDTO = securityService.securityPersonDetail(paramDTO);
		result.setSuccessful(true);
		result.setData(resultDTO);
		return result;
	}

	/**
	 * 持证人员分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("holdCerAnalyse")
	public @ResponseBody AjaxResult holdCerAnalyse(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		List<EchartMapData> mapList = securityService.holdCerAnalyse(paramDTO);
		result.setSuccessful(true);
		result.setData(mapList);
		return result;
	}

	/**
	 * 实名认证分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("authAnalyse")
	public @ResponseBody AjaxResult authAnalyse(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		User currentUser= arsUtil.getCurrentUser();
		String areaCode = paramDTO.getAreaCode();
		if(StringUtil.isEmpty(areaCode)){
			if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
				areaCode = Constants.BEIJING +"0000";
			}else {
				areaCode = currentUser.getPolice().getAreacode();
				paramDTO.setUserid(currentUser.getId());
				paramDTO.setPath(currentUser.getPolice().getPath());
			}
			paramDTO.setAreaCode(areaCode);
		}
		PageResultDTO resultDTO = securityService.authAnalyse(paramDTO);
		result.setSuccessful(true);
		result.setData(resultDTO);
		return result;
	}
}
