package com.bcxin.ars.rest.statistics;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.service.statistics.FlowStatisticsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 业务情况统计（保安员，保安公司）
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Controller
@RequestMapping("statistics/flow")
public class FlowStatisticsController {

	Logger logger = LoggerFactory.getLogger(FlowStatisticsController.class);
	
	@Autowired
	private FlowStatisticsService flowService;
	
	/**
	 * 流程情况分析
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("flowDetail")
	public @ResponseBody AjaxResult processDetail(ParamDTO paramDTO) throws Exception{
		AjaxResult result = new AjaxResult();
		List<Map> mapList = flowService.flowDetail(paramDTO);
		result.setSuccessful(true);
		result.setData(mapList);
		return result;
	}


}
