package com.bcxin.ars.rest.sb;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.report.PersonPolicyDto;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.service.sb.YearreportdataService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;

@Controller
@RequestMapping("yearreportdata")
public class YearreportdataController {

    private Logger logger = LoggerFactory.getLogger(YearreportdataController.class);

    @Autowired
    private YearreportdataService yearreportdataService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
    /**
     * 根据用户ID获取
     * @return
     */
    @RequestMapping("findByUserId")
    public @ResponseBody
    AjaxResult findByUserId() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
          User user = arsUtil.getCurrentUser();
            try {
                //如果用户不存在则抛出异常 add start 2018-06-09 subh
                if(user==null){
                    throw new ArsException("用户不存在！！");
                }

                //企业年报提醒
                Config yearReportRemindConfig =configUtils.getConfigByKey(Constants.YEAR_REPORT_REMIND);
                if (yearReportRemindConfig != null && Constants.YEAR_REPORT_REMIND_YES.equals(yearReportRemindConfig.getValue())) {
                    Config remindTime = configUtils.getConfigByKey(Constants.YEAR_REPORT_REMIND_ENDTIME);
                    if(remindTime != null) {
                        Date remindDate = DateUtil.convertStringToDate(remindTime.getValue());
                        if (remindDate.getTime() <= System.currentTimeMillis()) {
                            result.setSuccessful(false);
                            return result;
                        }
                    }
                    Yearreportdata yearreportdata = yearreportdataService.findByUserId(user.getId());
                    result.setSuccessful(true);
                    result.setData(yearreportdata);
                }
            } catch(Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据用户ID获取
     * @return
     */
    @RequestMapping("getPersonPolicyReportByCompanyId")
    public @ResponseBody
    AjaxResult getPersonPolicyReportByCompanyId() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            try {
                PersonPolicyDto personPolicyDto = yearreportdataService.getPersonPolicyReportByCompanyId();
                result.setSuccessful(true);
                result.setData(personPolicyDto);
            } catch(Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据用户ID获取
     * @return
     */
    @RequestMapping("updateDateForUserId")
    public @ResponseBody
    AjaxResult updateDateForUserId() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            try {
                Yearreportdata yearreportdata = yearreportdataService.findByUserId(user.getId());
                if(yearreportdata == null || (
                        !ApprovalState.DSH.equals(yearreportdata.getApprovalstate())
                        && !ApprovalState.SPZ.equals(yearreportdata.getApprovalstate())
                        && !ApprovalState.SHTG.equals(yearreportdata.getApprovalstate())
                )){
                    yearreportdataService.saveOrUpdateDateForUserId(yearreportdata);
                    yearreportdata = yearreportdataService.findByUserId(user.getId());
                }
                result.setSuccessful(true);
                result.setData(yearreportdata);
            } catch(Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新年度
     * @param yearreportdata
     * @return
     */
    @RequestMapping("update")
    public @ResponseBody
    AjaxResult update(Yearreportdata yearreportdata) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.saveOrUpdate(yearreportdata);
            result.setSuccessful(true);
            result.setData(yearreportdata);

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("edit")
    public @ResponseBody
    AjaxResult edit(Yearreportdata yearreportdata) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.edit(yearreportdata);
            result.setSuccessful(true);
            result.setData(yearreportdata);

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 更新指派民警iD
     * @param yearreportdata
     * @return
     */
    @RequestMapping("updatePoliceId")
    public @ResponseBody
    AjaxResult updatePoliceId(Yearreportdata yearreportdata) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.updatePoliceId(yearreportdata);
            result.setSuccessful(true);
            result.setData(yearreportdata);

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 更新年度
     * @param yearreportdata
     * @return
     */
    @RequestMapping("updateOperator")
    public @ResponseBody
    AjaxResult updateOperator(Yearreportdata yearreportdata) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.updateOperator(yearreportdata);
            result.setSuccessful(true);
            result.setData(yearreportdata);

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 查询企业年报数据统计
     *
     * @param searchDto
     * @return
     * @throws Exception
     */
    @RequestMapping("yearReportSearch")
    public @ResponseBody
    Object yearReportSearch(YearReportsSearchDto searchDto, HttpServletResponse resp) throws Exception {
        try {
            CTLUtil.out(yearreportdataService.queryYearReportList(searchDto), resp);//进行查询，并转换
        } catch (Exception e) {
            throw e;
        }
        return null;
    }

    /**
     * 查询企业年报
     *
     * @param searchDto
     * @return
     * @throws Exception
     */
    @RequestMapping("search")
    public @ResponseBody AjaxResult search(YearReportsSearchDto searchDto) throws Exception {
    	AjaxResult result = new AjaxResult();
        try {
        	searchDto = yearreportdataService.search(searchDto);
            result.setSuccessful(true);
            result.setData(searchDto);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Yearreportdata yearreportdata = yearreportdataService.findById(id);
            result.setSuccessful(true);
            result.setData(yearreportdata);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    
    @RequestMapping("updateSealState")
    @RequiresPermissions("yearreport:seal")
    public @ResponseBody AjaxResult updateSealState(Long yearReportId,String sealState) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.updateSealState(yearReportId,sealState);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     *给为填写年报公司的法人发信息提示
     */
    public @ResponseBody AjaxResult sendMessageForLegalPerson(String userId)throws Exception{

        AjaxResult result = new AjaxResult();
        try {
            yearreportdataService.sendMessageForLegalPerson(userId);
            result.setSuccessful(true);
        }catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    
    /**
     *检查线上平台保险购买方案
     */
    @RequestMapping("checkOnLinePolicy")
    public @ResponseBody AjaxResult checkOnLinePolicy()throws Exception{
    	AjaxResult result = new AjaxResult();
    	try {
    		result.setSuccessful(yearreportdataService.checkOnLinePolicy());
    	}catch(Exception e) {
    		logger.error(e.getMessage(), e);
    		throw e;
    	}
    	return result;
    }
    
    /**
     *检查出资人信息有没有填写
     */
    @RequestMapping("checkInvestorInput")
    public @ResponseBody AjaxResult checkInvestorInput()throws Exception{
    	
    	AjaxResult result = new AjaxResult();
    	try {
    		result.setSuccessful(yearreportdataService.checkInvestorInput());
    	}catch(Exception e) {
    		logger.error(e.getMessage(), e);
    		throw e;
    	}
    	return result;
    }

	@RequestMapping("queryTable")
    @RequiresPermissions("yearreport:query")
    public @ResponseBody
    PageResult queryTable(YearReportsSearchDto searchDto, HttpServletResponse response) throws Exception {
        return yearreportdataService.queryTable(searchDto);//进行查询，并转换
    }




    @RequestMapping("list/index")

    public ModelAndView listIndex(YearReportsSearchDto searchDto){
        ModelAndView view = new ModelAndView("yearreportdata/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("yearreport:query")
    @ResponseBody
    public AjaxPageResponse searchForPage(YearReportsSearchDto dto, AjaxPageResponse<YearReportDto> page){
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        dto.setPoliceBusiness(false);
        yearreportdataService.searchForPage(dto,page);
        return page;
    }












}
