package com.bcxin.ars.rest.sb;

import com.bcxin.ars.util.Constants;
import com.bcxin.ars.dto.sb.VehicleSearchDto;
import com.bcxin.ars.model.sb.Vehicle;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.VehicleLogSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.VehicleLog;
import com.bcxin.ars.service.sb.VehicleLogService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("vehicleLog")
public class VehicleLogController {

	Logger logger = LoggerFactory.getLogger(VehicleLogController.class);
	
	@Autowired
	private VehicleLogService vehicleLogService;
	
	@Autowired
	private ArsUtil arsUtil;




	@RequestMapping("list/index")
	public ModelAndView listIndex(VehicleLogSearchDto searchDto){
		ModelAndView view = new ModelAndView("/vehicle/log");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(VehicleLogSearchDto dto, AjaxPageResponse<VehicleLog> page){
		User user = arsUtil.getCurrentUser();
		if(user != null) {
			if (dto.getUserid() == null) {
				if(user.getPlatform() == Constants.PLATFORM_COMPANY){
					dto.setUserid(user.getId());
				}
			}
			vehicleLogService.searchForPage(dto,page);
		}
		return page;
	}




	@RequestMapping("search")
	public @ResponseBody AjaxResult search(VehicleLogSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(user.getPlatform() == Constants.PLATFORM_COMPANY){
					dto.setUserid(user.getId());
				}
				VehicleLogSearchDto list = vehicleLogService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(VehicleLog vehicleLog) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				vehicleLogService.saveOrUpdate(vehicleLog);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(VehicleLog vehicleLog) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				vehicleLogService.delete(vehicleLog);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			VehicleLog vehicleLog = vehicleLogService.findById(id);
			result.setSuccessful(true);
			result.setData(vehicleLog);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
