package com.bcxin.ars.rest.sb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SubsidiarypersonSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Subsidiaryperson;
import com.bcxin.ars.service.sb.SubsidiarypersonService;
import com.bcxin.ars.service.util.ArsUtil;

@Controller
@RequestMapping("subsidiaryperson")
public class SubsidiarypersonController {

	Logger logger = LoggerFactory.getLogger(SubsidiarypersonController.class);
	
	@Autowired
	private SubsidiarypersonService subsidiarypersonService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(SubsidiarypersonSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				SubsidiarypersonSearchDto list = subsidiarypersonService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Subsidiaryperson subsidiaryperson) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				subsidiarypersonService.saveOrUpdate(subsidiaryperson);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Subsidiaryperson subsidiaryperson = subsidiarypersonService.findById(id);
			result.setSuccessful(true);
			result.setData(subsidiaryperson);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
