package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.SponsorlicenseDto;
import com.bcxin.ars.dto.sb.SponsorlicenseSearchDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("sponsorlicense")
public class SponsorlicenseController {

    private Logger logger = LoggerFactory.getLogger(SponsorlicenseController.class);

    @Resource
    private SponsorlicenseService sponsorlicenseService;

    @Resource
    private SecurityGuardService securityGuardService;

    @Resource
    private SecurityCompanyService securityCompanyService;

    @Resource
    private SecurityPersonService securityPersonService;

    @Autowired
    private GXSSOUtil gxssoUtil;

    @Resource
    private ArsUtil arsUtil;
    
    /**
     * 查询培训单位信息
     * @param dto
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AjaxResult findAll(SponsorlicenseSearchDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SponsorlicenseSearchDto data = sponsorlicenseService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }




//    sponsorlicense

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(SponsorlicenseSearchDto searchDto){
        ModelAndView view = new ModelAndView("sponsorlicense/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("sponsorlicense:query")
    public AjaxPageResponse searchForPage(SponsorlicenseSearchDto dto, AjaxPageResponse<Sponsorlicense> page){
        sponsorlicenseService.searchForPage(dto,page);
        return page;
    }



    @RequestMapping("/searchSponsorlicenseList_table")
    @ResponseBody
    @RequiresPermissions("sponsorlicense:query")
    public PageResult searchSponsorlicenseList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                     HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if (params.get("checkType")!=null) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (user.getPlatform() == 2) {
                    p.put("userid",user.getId());
                }else{
                    //角色列表
                    List<PoliceRole> roles = user.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        return sponsorlicenseService.searchSponsorlicenseList_table(p);//进行查询，并转换
    }



    @RequestMapping("search")
    public @ResponseBody AjaxResult search(SponsorlicenseSearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	/*if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}*/
                result.setSuccessful(true);
                result.setData(sponsorlicenseService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Sponsorlicense sponsorlicense, HttpSession httpSession) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                sponsorlicenseService.saveOrUpdate(sponsorlicense);
                String projectNo= (String) httpSession.getAttribute("projectNo");
                if (StringUtil.isNotEmpty(projectNo)){
                    String token= (String) httpSession.getAttribute("gxssotoken");
                    gxssoUtil.reportData(token,projectNo);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }




    @RequestMapping("updatePoliceId")
    public @ResponseBody AjaxResult updatePoliceId(Sponsorlicense sponsorlicense) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                sponsorlicenseService.updatePoliceId(sponsorlicense);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
  //  @RequiresPermissions("sponsorlicense:view")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(id);
            result.setSuccessful(true);
            result.setData(sponsorlicense);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("getDetail/{id}")
    //  @RequiresPermissions("sponsorlicense:view")
    public @ResponseBody AjaxResult getDetail(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SponsorlicenseDto sponsorlicense = sponsorlicenseService.getDetail(id);
            result.setSuccessful(true);
            result.setData(sponsorlicense);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Sponsorlicense sponsorlicense = sponsorlicenseService.findByUser(user.getId());
                if(sponsorlicense != null){
                    result.setSuccessful(true);
                    result.setData(sponsorlicense);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Sponsorlicense sponsorlicense = sponsorlicenseService.findById(businessid);
                if(sponsorlicense != null){
                	sponsorlicense.setCensorstatus(approvalstate);
                	sponsorlicenseService.updateCensorStatus(sponsorlicense);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



    /**
     * 账号生成
     * @return
     */
    @RequestMapping("buildAccount/{id}")
    public @ResponseBody AjaxResult buildAccount(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(id);

            //源实体类的列，目标实体类的列
                   String[] srccol = {"companyname","address","representative","legalPersonNo","phone","district"};
                   String[] desccol = {"name","location","legalPerson","legalPersonNo","tel","areaCode"};

            //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
            String[] key = {};
            String[] value = {};
            //生成实体
            Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sponsorlicense,new SecurityCompany(),key,value);
            SecurityCompany securityCompany =(SecurityCompany)desc;
            securityCompany.setUser(new User());
            securityCompany.getUser().setId(sponsorlicense.getUserid());
            securityCompanyService.saveOrUpdate(securityCompany);
            securityCompany.getUser().setId(null);
            securityCompanyService.updateCompanyAccout(securityCompany);

            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    
    @RequestMapping("findByAreaReport")
	public @ResponseBody AjaxResult findByAreaReport(ReportDataSearchDto searchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			JSONObject resultObj = new JSONObject();
			DecimalFormat df = new DecimalFormat("#.0");
			List<ReportData> data = sponsorlicenseService.findByAreaReport(searchDto);
			List<String> nameList = new ArrayList<String>();
			Long total = 0l;
			for (ReportData reportData : data) {
				total = total + reportData.getValue();
			}
			for (ReportData reportData : data) {
				System.out.println(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
				nameList.add(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
				reportData.setName(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
//				nameList.add(reportData.getName());
			}
			resultObj.put("names", nameList);
			resultObj.put("values", data);
			resultObj.put("total", total);
			result.setSuccessful(true);
			result.setData(resultObj);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


    @RequestMapping("validateSecurityGuard")
    public @ResponseBody AjaxResult validateSecurityGuard(Sponsorlicense sponsorlicense) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                String data = securityGuardService.validateSecurityGuard(sponsorlicense);
                result.setData(data);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
