package com.bcxin.ars.rest.sb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ShareholderSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.service.sb.ShareholderService;
import com.bcxin.ars.service.util.ArsUtil;

@Controller
@RequestMapping("shareholder")
public class ShareholderController {

	Logger logger = LoggerFactory.getLogger(ShareholderController.class);
	
	@Autowired
	private ShareholderService shareholderService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ShareholderSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				ShareholderSearchDto list = shareholderService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Shareholder shareholder) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				shareholderService.saveOrUpdate(shareholder);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Shareholder shareholder = shareholderService.findById(id);
			result.setSuccessful(true);
			result.setData(shareholder);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Shareholder shareholder = shareholderService.findById(businessid);
                if(shareholder != null){
                	shareholder.setCensorstatus(approvalstate);
                	shareholderService.updateCensorStatus(shareholder);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
