package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.SecAssociationRatingPageSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.SecAssociationRating;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.SecAssociationRatingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 保安协会等级评定Controller
 * 
 * @author lin
 * @date 2021-04-20
 */
@Controller
@RequestMapping("/rating")
public class SecAssociationRatingController{
    Logger logger = LoggerFactory.getLogger(SecAssociationRatingController.class);

    @Autowired
    private SecAssociationRatingService secAssociationRatingService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private ArsUtil arsUtil;

    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("rating:view")
    public ModelAndView listIndex(SecAssociationRatingPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("rating/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("rating:view")
    public AjaxPageResponse searchForPage(SecAssociationRatingPageSearchDto dto, AjaxPageResponse<SecAssociationRating> page){
        secAssociationRatingService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param secAssociationRating
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("rating:view")
    public ModelAndView detailIndex(SecAssociationRating secAssociationRating){
        ModelAndView view = new ModelAndView("rating/detail");

        if(secAssociationRating.getId() != null){
            view.addObject("record",secAssociationRatingService.findById(secAssociationRating.getId()));
        }else {
            view.addObject("record", secAssociationRating);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param secAssociationRating
     * @return
     */
    @RequestMapping("edit/index")
    @RequiresPermissions(logical = Logical.OR,value ={"rating:add"})
    public ModelAndView editIndex(SecAssociationRating secAssociationRating){
        ModelAndView view = new ModelAndView("rating/edit");

        if(secAssociationRating.getId() != null){
            view.addObject("record",secAssociationRatingService.findById(secAssociationRating.getId()));
        }else {
            secAssociationRating.setComName(arsUtil.getCurrentUser().getRealname());
            if(secAssociationRating.getPerId() != null){
                SecurityPerson person = securityPersonService.findById(secAssociationRating.getPerId());
                if(person != null){
                    secAssociationRating.setRealName(person.getRealName());
                    secAssociationRating.setPhone(person.getPhone());
                }
            }
            view.addObject("record", secAssociationRating);
        }

        return view;
    }

    /**
     * 受理页面
     * @param secAssociationRating
     * @return
     */
    @RequestMapping("approve/index")
    @RequiresPermissions(logical = Logical.OR,value ={"rating:approve"})
    public ModelAndView approveIndex(SecAssociationRating secAssociationRating){
        ModelAndView view = new ModelAndView("rating/approve");
        if(secAssociationRating.getId() != null){
            view.addObject("record",secAssociationRatingService.findById(secAssociationRating.getId()));
        }
        return view;
    }

    /**
     * 保存
     * @param secAssociationRating
     * @return
     */
    @RequestMapping("save")
    @RequiresPermissions(logical = Logical.OR,value ={"rating:add"})
    @ResponseBody
    public AjaxResult save(SecAssociationRating secAssociationRating){
        AjaxResult result = new AjaxResult();
        try {
            secAssociationRatingService.save(secAssociationRating);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 保存
     * @param secAssociationRating
     * @return
     */
    @RequestMapping("approve")
    @RequiresPermissions(logical = Logical.OR,value ={"rating:approve"})
    @ResponseBody
    public AjaxResult approve(SecAssociationRating secAssociationRating){
        AjaxResult result = new AjaxResult();
        try {
            secAssociationRatingService.approve(secAssociationRating);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
