package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbSponsorlicenseVmanagerSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.service.sb.SbSponsorlicenseVmanagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("sbSponsorlicenseVmanager")
public class SbSponsorlicenseVmanagerController {

	Logger logger = LoggerFactory.getLogger(SbSponsorlicenseVmanagerController.class);
	
	@Autowired
	private SbSponsorlicenseVmanagerService sbSponsorlicenseVmanagerService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(SbSponsorlicenseVmanagerSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				SbSponsorlicenseVmanagerSearchDto list = sbSponsorlicenseVmanagerService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(SbSponsorlicenseVmanager sbSponsorlicenseVmanager) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				sbSponsorlicenseVmanagerService.saveOrUpdate(sbSponsorlicenseVmanager);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSponsorlicenseVmanager sbSponsorlicenseVmanager = sbSponsorlicenseVmanagerService.findById(id);
			result.setSuccessful(true);
			result.setData(sbSponsorlicenseVmanager);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	SbSponsorlicenseVmanager sbSponsorlicenseVmanager = sbSponsorlicenseVmanagerService.findById(businessid);
                if(sbSponsorlicenseVmanager != null){
					sbSponsorlicenseVmanager.setCensorstatus(approvalstate);
                	sbSponsorlicenseVmanagerService.updateCensorStatus(sbSponsorlicenseVmanager);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
