package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.dto.sb.SafetySearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.model.sb.Safety;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.SafetyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("safety")
public class SafetyController {

	Logger logger = LoggerFactory.getLogger(SafetyController.class);
	
	@Autowired
	private SafetyService safetyService;

	@Autowired
	private SecurityPersonService personService;
	
	@Autowired
	private ArsUtil arsUtil;




	@RequestMapping("list/index")
	public ModelAndView listIndex(SafetySearchDto searchDto){
		ModelAndView view = new ModelAndView("/safety/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(SafetySearchDto dto, AjaxPageResponse<Safety> page){
		User user = arsUtil.getCurrentUser();
		if(user != null) {
			if (user.getPlatform() != 1) {
				if (dto.getUserid() == null) {
					dto.setUserid(user.getId());
				}
			}
			safetyService.searchForPage(dto, page);
		}
		return page;
	}






	@RequestMapping("search")
	public @ResponseBody AjaxResult search(SafetySearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(user.getPlatform() != 1){
					if(dto.getUserid() == null) {
						dto.setUserid(user.getId());
					}
				}
				SafetySearchDto list = safetyService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Safety safety) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				safetyService.saveOrUpdate(safety);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Safety safety) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				safetyService.delete(safety);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Safety safety = safetyService.findById(id);
			result.setSuccessful(true);
			result.setData(safety);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
