package com.bcxin.ars.rest.sb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.PersonworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Personworkexperience;
import com.bcxin.ars.service.sb.PersonworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;

@Controller
@RequestMapping("personworkexperience")
public class PersonworkexperienceController {

	Logger logger = LoggerFactory.getLogger(PersonworkexperienceController.class);
	
	@Autowired
	private PersonworkexperienceService personworkexperienceService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(PersonworkexperienceSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				PersonworkexperienceSearchDto list = personworkexperienceService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Personworkexperience personworkexperience) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				personworkexperienceService.saveOrUpdate(personworkexperience);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Personworkexperience personworkexperience) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				personworkexperienceService.delete(personworkexperience);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Personworkexperience personworkexperience = personworkexperienceService.findById(id);
			result.setSuccessful(true);
			result.setData(personworkexperience);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
