package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.PersonGradeSearchDto;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @author linqinglin
 * @date 2019/12/31 0031 15:26
 */
@Controller
@RequestMapping("personGrade")
public class PersonGradeController {

    private static final Logger logger = LoggerFactory.getLogger(PersonGradeController.class);

    @Autowired
    private PersonGradeService personGradeService;

    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("/list/page")
    public ModelAndView listPage(PersonGradeSearchDto searchDto) {
        ModelAndView view = new ModelAndView("personGrade/layList");
        view.addObject("record",searchDto);
        return view;
    }

    /***
     * 北京补贴人员明细
     * @return 页面路径
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("/list/Subsidypage")
    public ModelAndView listSubsidyPage(PersonGradeSearchDto searchDto) {
        ModelAndView view = new ModelAndView("personGrade/SubsidyList");
        view.addObject("record",searchDto);
        return view;
    }


    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("/list/pageForClass")
    public ModelAndView listPageForClass(PersonGradeSearchDto searchDto) {
        ModelAndView view = new ModelAndView("personGrade/listForClass");
        view.addObject("record",searchDto);
        return view;
    }


    /***
     * 分页查询
     * @param searchDto 查询参数
     * @param page 返回查询列表
     * @throws Exception 异常
     */
    @RequestMapping("searchForPage")
    public @ResponseBody
    AjaxPageResponse searchForPage(PersonGradeSearchDto searchDto, AjaxPageResponse page) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            personGradeService.searchForPage(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }

    /***
     * 北京补贴人员明细
     * @return 查询
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("searchForPageBySubsidy")
    public @ResponseBody
    AjaxPageResponse searchForPageBySubsidy(PersonGradeSearchDto searchDto, AjaxPageResponse page) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            personGradeService.searchForPageBySubsity(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }

    @RequestMapping("detail/page/{id}")
    public ModelAndView detailPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView("personGrade/detail");
        view.addObject("content",personGradeService.findById(id));
        return view;
    }

}
