package com.bcxin.ars.rest.sb;

import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.sb.PersonCertificateOrderService;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * Created by Administrator on 2018/04/11 0011.
 */
@Controller
@RequestMapping("personCertificateOrder")
public class PersonCertificateOrderController {

    @Autowired
    private PersonCertificateOrderService personCertificateOrderService;

    @Autowired
    private ArsRestUtil arsUtil;

    @RequestMapping("orderList/init")
    public String orderListInit(){
        return "onlinepay/orderList";
    }

    @RequestMapping("selectPeople/init")
    public String selectPeopleInit(){
        return "onlinepay/selepeople";
    }

    @RequestMapping("confirmOrder/init")
    public String confirmOrderInit(){
        return "onlinepay/confirmOrder";
    }

    @RequestMapping("queryTable")
    public @ResponseBody Object queryTable(@RequestParam Map<Object, Object> params, ModelMap model,
                                           HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

        if(p.get("areaCode")!=null  && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            String areacode = p.get("areaCode").toString();
            if (areacode.endsWith("0000")) {//省
                p.put("areaCode",areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("areaCode",areacode.substring(0, 4) + "__");
            }
        }
        User user =	arsUtil.getCurrentUser();

        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());
        CTLUtil.out(personCertificateOrderService.queryOrderList(p), resp);//进行查询，并转换
        return null;
    }
}
