package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.sb.PerCheckRecordPageSearchDto;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.bcxin.ars.service.sb.PerCheckRecordService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 抽查记录Controller
 *
 * @author lin
 * @date 2020-12-09抽查
 */
@Controller
@RequestMapping("/checkRecord")
public class PerCheckRecordController {

    @Autowired
    private PerCheckRecordService perCheckRecordService;


    /**
     * 管理列表页面
     *
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(PerCheckRecordPageSearchDto searchDto) {
        ModelAndView view = new ModelAndView("checkRecord/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     *
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PerCheckRecordPageSearchDto dto,
                                          AjaxPageResponse<PerCheckRecord> page) {
        perCheckRecordService.searchForPage(dto, page);
        return page;
    }

}
