package com.bcxin.ars.rest.sb;


import com.bcxin.ars.dto.page.PerCerGrantPageSearchDto;
import com.bcxin.ars.model.sb.PerCerGrant;
import com.bcxin.ars.service.sb.PerCerGrantService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.apache.shiro.authz.annotation.RequiresPermissions;


/**
 * 保安员证核发Controller
 * 
 * @author lin
 * @date 2022-09-01
 */
@Controller
@RequestMapping("/perCerGrant")
public class PerCerGrantController{
    Logger logger = LoggerFactory.getLogger(PerCerGrantController.class);

    @Autowired
    private PerCerGrantService perCerGrantService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("perCerGrant:view")
    public ModelAndView listIndex(PerCerGrantPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("perCerGrant/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("perCerGrant:view")
    public AjaxPageResponse searchForPage(PerCerGrantPageSearchDto dto, AjaxPageResponse<PerCerGrant> page){
        perCerGrantService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param perCerGrant
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("perCerGrant:view")
    public ModelAndView detailIndex(PerCerGrant perCerGrant){
        ModelAndView view = new ModelAndView("perCerGrant/detail");

        if(perCerGrant.getId() != null){
            view.addObject("record",perCerGrantService.findById(perCerGrant.getId()));
        }else {
            view.addObject("record", perCerGrant);
        }

        return view;
    }

    /**
     * 审批页面
     * @param perCerGrant
     * @return
     */
    @RequestMapping("approve/index")
    public ModelAndView approveIndex(PerCerGrant perCerGrant){
        ModelAndView view = new ModelAndView("perCerGrant/approve");

        if(perCerGrant.getId() != null){
            view.addObject("record",perCerGrantService.findById(perCerGrant.getId()));
        }else {
            view.addObject("record", perCerGrant);
        }

        return view;
    }

}
