package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.LegalchangeworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("legalchangeworkexperience")
public class LegalchangeworkexperienceController {

	Logger logger = LoggerFactory.getLogger(LegalchangeworkexperienceController.class);
	
	@Autowired
	private LegalchangeworkexperienceService workexperienceService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(LegalchangeworkexperienceSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				LegalchangeworkexperienceSearchDto list = workexperienceService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Legalchangeworkexperience workexperience) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				workexperienceService.saveOrUpdate(workexperience);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult update(Long workexperienceId) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				workexperienceService.delete(workexperienceId);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Legalchangeworkexperience workexperience = workexperienceService.findById(id);
			result.setSuccessful(true);
			result.setData(workexperience);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findByLegalchangeId")
	public @ResponseBody AjaxResult findByLegalchangeId(Long legalchangeId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Legalchangeworkexperience> workexperiences = workexperienceService.findByLegalchangeId(legalchangeId);
			result.setSuccessful(true);
			result.setData(workexperiences);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
