package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.dto.sb.HandleGuideSearchDto;
import com.bcxin.ars.enums.BusinessType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.model.sb.HandleGuide;
import com.bcxin.ars.service.sb.HandleGuideService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.CTLUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping("handleGuide")
public class HandleGuideController {

	Logger logger = LoggerFactory.getLogger(HandleGuideController.class);
	
	@Autowired
	private HandleGuideService handleGuideService;



	@Autowired
	private ArsUtil arsUtil;

	@RequestMapping("findByBusinessType")
	public @ResponseBody AjaxResult findByBusinessType(String businessType,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			HandleGuide handleGuide = handleGuideService.findByBusinessType(businessType,type);
			result.setSuccessful(true);
			result.setData(handleGuide);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	@RequestMapping("list/init")
	public String listInit(){
		return "/handleGuide/list";
	}

	@RequestMapping("search")
	public @ResponseBody Object search(HandleGuideSearchDto searchDto, HttpServletResponse response) throws Exception {
		try {
			CTLUtil.out(handleGuideService.search(searchDto), response);//进行查询，并转换
		} catch (Exception e) {
			throw e;
		}
		return null;
	}

/*  20200824dt*/
	@RequestMapping("list/index")
	public ModelAndView listIndex(HandleGuideSearchDto searchDto){
		ModelAndView view = new ModelAndView("/handleGuide/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(HandleGuideSearchDto dto, AjaxPageResponse<HandleGuide> page){
		try {
			handleGuideService.searchForPage(dto, page);
		} catch (Exception e) {
			throw e;
		}
		return page;
	}







	@RequestMapping("edit/{id}")
	public ModelAndView editInit(@PathVariable Long id){
		ModelAndView result = new ModelAndView("/handleGuide/edit");
		HandleGuide handleGuide = handleGuideService.findById(id);
		handleGuide.setBusinessType(BusinessType.convertName(handleGuide.getBusinessType()));
			result.addObject("handleGuide",handleGuide);
		return result;
	}

	@RequestMapping("edit/index")
	public ModelAndView editInit2(HandleGuide handleGuide){
		ModelAndView result = new ModelAndView("/handleGuide/edit");
		Long id = handleGuide.getId();
		handleGuide = handleGuideService.findById(id);
		handleGuide.setBusinessType(BusinessType.convertName(handleGuide.getBusinessType()));
		result.addObject("handleGuide",handleGuide);
		return result;
	}

	@RequestMapping("viewDetail/{id}")
	public ModelAndView viewDetail(@PathVariable Long id){
		ModelAndView result = new ModelAndView("/handleGuide/view");
		HandleGuide handleGuide = handleGuideService.findById(id);
		result.addObject("handleGuide",handleGuide);
		return result;
	}


	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult saveOrUpdate(HandleGuide handleGuide) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			handleGuideService.saveOrUpdate(handleGuide);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


}
