package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.sb.GradeSubsidyBatchService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.SubsidyConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.ss.usermodel.*;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 等级证补贴批次控制器
 *
 * @author linqinglin
 * @Date 2020-05-18 19:43:23
 */
@Controller
@RequestMapping("gradeSubsidyBatch")
public class GradeSubsidyBatchController {

    Logger logger = LoggerFactory.getLogger(GradeSubsidyBatchController.class);

    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private GradeSubsidyBatchService gradeSubsidyBatchService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private SubsidyConfigService subsidyConfigService;

    @Autowired
    private ArsUtil arsUtil;
    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    @RequiresPermissions("gradeSubsidyBatch:query")
    public ModelAndView listIndex(GradeSubsidyBatchPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("trainList/index")
    public ModelAndView trainListIndex(GradeSubsidyBatchPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/trainList");
        view.addObject("record",searchDto);
        return view;
    }
    @RequestMapping("upload")
    public ModelAndView upload(String subsidyCerType){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/upload");
        view.addObject("subsidyCerType",subsidyCerType);
        return view;
    }

    /**
     * 查看页面
     * @param gradeSubsidyBatch
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(GradeSubsidyBatch gradeSubsidyBatch){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/detail");
        GradeSubsidyBatch subsidyBatch = gradeSubsidyBatchService.findById(gradeSubsidyBatch.getId());
        view.addObject("record",subsidyBatch);

        String businessType = BusinessType.DJZBT;

        if(Constants.SUBSIDYCERTYPE_ZGZ.equals(subsidyBatch.getSubsidyCerType())){
            businessType = BusinessType.ZGZBT;
        }

        view.addObject("approval", approvalService.findBybusinessidAndType(gradeSubsidyBatch.getId(), businessType));
        return view;
    }





    /**
     * 新增编辑页面
     * @param gradeSubsidyBatch
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(GradeSubsidyBatch gradeSubsidyBatch){
        ModelAndView view = new ModelAndView("gradeSubsidyBatch/edit");
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany securityCompany = securityCompanyService.findByUserid(currentUser.getId());
        view.addObject("securityCompany",securityCompany);

        if(gradeSubsidyBatch.getId() != null){
            view.addObject("record",gradeSubsidyBatchService.findById(gradeSubsidyBatch.getId()));
        }else {
            view.addObject("record", gradeSubsidyBatch);
        }
        return view;
    }

    /**
     * 保存
     * @param gradeSubsidyBatch
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(GradeSubsidyBatch gradeSubsidyBatch){
        AjaxResult result = new AjaxResult();
        try {
            if(StringUtil.isNotEmpty(gradeSubsidyBatch.getSubsidyMoney())) {
                //元转万元
//            gradeSubsidyBatch.setSubsidyMoney(new BigDecimal(gradeSubsidyBatch.getSubsidyMoney()).divide(new BigDecimal(10000)).setScale(4).toString());
                gradeSubsidyBatch.setSubsidyMoney(new BigDecimal(gradeSubsidyBatch.getSubsidyMoney()).divide(new BigDecimal(1)).setScale(2).toString());
            }
            gradeSubsidyBatchService.save(gradeSubsidyBatch);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse<GradeSubsidyBatch> page){
        gradeSubsidyBatchService.searchForPage(dto,page);
        return page;
    }

    /**
     * 打回
     * @param gradeSubsidyBatch
     * @return
     */
    @RequestMapping("repulse")
    public @ResponseBody AjaxResult repulse(GradeSubsidyBatch gradeSubsidyBatch){
        AjaxResult result = new AjaxResult();
        try {
            //获取当前用户信息
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                gradeSubsidyBatchService.repulse(gradeSubsidyBatch);
                //成功之返回给前端
                result.setSuccessful(true);
                result.setMsg("更新成功！");
            } else {
                //用户不存在则提示错误信息
                result.setMsg("用户未登陆，请重新登陆！");
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 补充上传承诺书
     * @param gradeSubsidyBatch
     * @return
     */
    @RequestMapping("uploadCommitFile")
    public @ResponseBody AjaxResult uploadCommitFile(GradeSubsidyBatch gradeSubsidyBatch){
        AjaxResult result = new AjaxResult();
        try {
            //获取当前用户信息
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                gradeSubsidyBatchService.uploadCommitFile(gradeSubsidyBatch);
                //成功之返回给前端
                result.setSuccessful(true);
                result.setMsg("更新成功！");
            } else {
                //用户不存在则提示错误信息
                result.setMsg("用户未登陆，请重新登陆！");
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 导出文件模板
     * by llc 2018-09-10
     */
    @RequestMapping("exportFileTemp")
    public @ResponseBody void exportFileTemp(String info,HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JSONObject.parseObject(info);
        String subsidyCerType = json.get("subsidyCerType").toString();
        if(Constants.SUBSIDYCERTYPE_ZGZ.equals(subsidyCerType)){
            exportQualificationFileTemp(json,request,response);
        }else{
            exportGradeFileTemp(json,request,response);
        }
    }
    /**
     * 导出承诺书模板
     * by llc 2018-09-10
     */
    @RequestMapping("exportCommitFileTemp")
    public @ResponseBody void exportCommitFileTemp(String subsidyCerType,HttpServletRequest request, HttpServletResponse response) throws Exception {
            InputStream inStream = null;
            OutputStream outStream = response.getOutputStream();
            try {
                String downFileName = "commitTemp"+subsidyCerType+".docx";
                inStream = request.getServletContext().getResourceAsStream(Constants.FILETEMPPATH + downFileName);
                //IOUtils.copy(inStream,outStream);
                /***  下载文件 ***/
                response.setContentType("application/octet-stream");
                response.addHeader("Content-Type", "application/octet-stream; charset=utf-8");
                String downLoadName = new String("承诺书.docx".getBytes("gbk"), "iso8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);

                //创建一个Buffer字符串
                byte[] buffer = new byte[1024];
                //每次读取的字符串长度，如果为-1，代表全部读取完毕
                int len = 0;
                //使用一个输入流从buffer里把数据读取出来
                while( (len=inStream.read(buffer)) != -1 ){
                    //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
                    outStream.write(buffer, 0, len);
                }

                inStream.close(); // 输入流关闭
                outStream.flush(); // 刷新输出流
                outStream.close(); // 输出流关闭
            } catch (Exception e) {
                e.printStackTrace();
            } finally { // 无论程序怎么运行，最后都要关闭流；
                if (inStream != null || outStream != null) {
                    try {
                        inStream.close();// 输入流关闭
                        outStream.close(); // 输出流关闭
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
    }


    /**
     * 等级证模板
     * @param json
     * @param request
     * @param response
     * @throws IOException
     */
    private void exportGradeFileTemp(JSONObject json,HttpServletRequest request,HttpServletResponse response) throws IOException {
        InputStream inStream = null;
        OutputStream out = response.getOutputStream();
        try {

            User user = arsUtil.getCurrentUser();

            SubsidyConfig subsidyConfig = null;

            List<SubsidyConfig> subsidyConfigs = subsidyConfigService.findAll();
            Map<String, SubsidyConfig> subsidyConfigMap = subsidyConfigs.stream().collect(Collectors.toMap(SubsidyConfig::getBusinessType, Function.identity()));

            String downFileName = "trainSubsidyApplyTemp.xls";

            String subsidyCerType = json.get("subsidyCerType").toString();
            if(Constants.SUBSIDYCERTYPE_ZGZ.equals(subsidyCerType)){
                downFileName = "";
            }

            inStream = request.getServletContext().getResourceAsStream(Constants.FILETEMPPATH + downFileName);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
            Row row2 = sheet.getRow(2);
            Cell cell = row2.getCell(0);
            cell.setCellValue(ExcelUtil.getCellValue(row2.getCell(0))+user.getRealname());

            Row row5 = sheet.getRow(9);
            Row row6 = sheet.getRow(6);
            Cell cell52 = row5.getCell(2);
            Cell cell53 = row5.getCell(3);
            Cell cell54 = row5.getCell(4);
            Cell cell55 = row5.getCell(5);
            Cell cell56 = row5.getCell(6);
            Cell cell57 = row5.getCell(7);
            Cell cell58 = row5.getCell(8);

            Cell cell62 = row6.getCell(2);
            Cell cell63 = row6.getCell(3);
            Cell cell64 = row6.getCell(4);
            Cell cell65 = row6.getCell(5);
            Cell cell66 = row6.getCell(6);
            Cell cell67 = row6.getCell(7);
            Cell cell68 = row6.getCell(8);


            subsidyConfig = subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_002);
            BigDecimal appraisal1 = new BigDecimal(subsidyConfig.getAmount());
            BigDecimal appraisal2 = new BigDecimal(json.get("appraisalNum").toString());
            BigDecimal appraisal3 = appraisal1.multiply(appraisal2).divide(new BigDecimal(1));

            cell52.setCellValue(json.get("appraisalNum").toString());
            cell53.setCellValue(appraisal3.setScale(4).toString());

            subsidyConfig = subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_001);
            BigDecimal complete1 = new BigDecimal(subsidyConfig.getAmount());
            BigDecimal complete2 = new BigDecimal(json.get("completeNum").toString());
            BigDecimal complete3 = complete1.multiply(complete2).divide(new BigDecimal(1));

            cell54.setCellValue(json.get("completeNum").toString());
            cell55.setCellValue(complete3.setScale(4).toString());

            subsidyConfig = subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_005);
            BigDecimal decimal1 = new BigDecimal(subsidyConfig.getAmount());
            BigDecimal decimal2 = new BigDecimal(json.get("perNum").toString());
            BigDecimal decimal3 = decimal1.multiply(decimal2).divide(new BigDecimal(1));

            cell56.setCellValue(json.get("perNum").toString());
            cell57.setCellValue(decimal3.setScale(4).toString());

            BigDecimal total = appraisal3.add(complete3).add(decimal3);
            cell58.setCellValue(total.setScale(4).toString());

            cell62.setCellValue(cell52.getStringCellValue());
            cell63.setCellValue(cell53.getStringCellValue());
            cell64.setCellValue(cell54.getStringCellValue());
            cell65.setCellValue(cell55.getStringCellValue());
            cell66.setCellValue(cell56.getStringCellValue());
            cell67.setCellValue(cell57.getStringCellValue());
            cell68.setCellValue(cell58.getStringCellValue());

            /***  下载文件 ***/
            response.setContentType("octets/stream");
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            String downLoadName = new String("职业技能培训补贴申请表.xls".getBytes("gbk"), "iso8859-1");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
            workBook.write(out);
            inStream.close(); // 输入流关闭
            out.flush(); // 刷新输出流
            out.close(); // 输出流关闭
        } catch (Exception e) {
            e.printStackTrace();
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (inStream != null || out != null) {
                try {
                    inStream.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 资格证模板
     * @param json
     * @param request
     * @param response
     * @throws IOException
     */
    private void exportQualificationFileTemp(JSONObject json,HttpServletRequest request,HttpServletResponse response) throws IOException {
        InputStream inStream = null;
        OutputStream out = response.getOutputStream();
        try {
            User user = arsUtil.getCurrentUser();
            SubsidyConfig subsidyConfig = subsidyConfigService.findByBusinessType(Constants.SUBSIDYBUSINESSTYPE_004);
            String downFileName = "trainQualificationSubsidyApplyTemp.xls";

            inStream = request.getServletContext().getResourceAsStream(Constants.FILETEMPPATH + downFileName);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet

            Row row2 = sheet.getRow(2);
            Cell cell = row2.getCell(0);
            cell.setCellValue(ExcelUtil.getCellValue(row2.getCell(0))+user.getRealname());

            Row row5 = sheet.getRow(5);
            Row row6 = sheet.getRow(6);
            Cell cell52 = row5.getCell(2);
            Cell cell53 = row5.getCell(3);
//            Cell cell54 = row5.getCell(4);

            BigDecimal decimal1 = new BigDecimal(subsidyConfig.getAmount());
            BigDecimal decimal2 = new BigDecimal(json.get("perNum").toString());
            BigDecimal decimal3 = decimal1.multiply(decimal2).divide(new BigDecimal(1));

            cell52.setCellValue(json.get("perNum").toString());
//            cell53.setCellValue(cell53.getStringCellValue());
            cell53.setCellValue(decimal3.toString());
//            cell54.setCellValue(cell53.getStringCellValue());

            Cell cell62 = row6.getCell(2);
            Cell cell63 = row6.getCell(3);
            Cell cell64 = row6.getCell(4);

            cell62.setCellValue(cell52.getStringCellValue());
            cell63.setCellValue(cell53.getStringCellValue());
//            cell64.setCellValue(cell54.getStringCellValue());

            /***  下载文件 ***/
            response.setContentType("octets/stream");
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            String downLoadName = new String("职业技能培训补贴申请表.xls".getBytes("gbk"), "iso8859-1");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
            workBook.write(out);
            inStream.close(); // 输入流关闭
            out.flush(); // 刷新输出流
            out.close(); // 输出流关闭
        } catch (Exception e) {
            e.printStackTrace();
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (inStream != null || out != null) {
                try {
                    inStream.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


}

