package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.FirearmsService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("firearms")
public class FirearmsController {

	Logger logger = LoggerFactory.getLogger(FirearmsController.class);
	
	@Autowired
	private FirearmsService firearmsService;

	@Autowired
	private SecurityPersonService personService;
	
	@Autowired
	private ArsUtil arsUtil;


	@RequestMapping("list/index")
	public ModelAndView listIndex(FirearmsSearchDto searchDto){
		ModelAndView view = new ModelAndView("/firearms/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(FirearmsSearchDto dto, AjaxPageResponse<Firearms> page){
		User user = arsUtil.getCurrentUser();
		if(user != null) {
			if (user.getPlatform() != 1) {
				if (dto.getUserid() == null) {
					dto.setUserid(user.getId());
				}
			}
			firearmsService.searchForPage(dto, page);
		}
		return page;
	}




	@RequestMapping("search")
	public @ResponseBody AjaxResult search(FirearmsSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(user.getPlatform() != 1) {
					if (dto.getUserid() == null) {
						dto.setUserid(user.getId());
					}
				}
				FirearmsSearchDto list = firearmsService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Firearms firearms) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				firearmsService.saveOrUpdate(firearms);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Firearms firearms) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				firearmsService.delete(firearms);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Firearms firearms = firearmsService.findById(id);
			result.setSuccessful(true);
			result.setData(firearms);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
