package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ConfesscompanyundoSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompanyundo;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sb.ConfesscompanyundoService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招撤销备案控制层
 */
@Controller
@RequestMapping("/confesscompanyundo")
public class ConfesscompanyundoController {

    private Logger logger = LoggerFactory.getLogger(ConfesscompanyController.class);
    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigService configService;
    /**
     * 申请界面
     * @return
     */
    @RequestMapping("/apply.do")
    public ModelAndView apply() {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("confesscompanyundo/apply");
        User user = arsUtil.getCurrentUser();
        if(user != null) {
            Confesscompanyundo confesscompanyundo=confesscompanyundoService.findUNSubmitByUser(user.getId());
            if(confesscompanyundo!=null){
                modelAndView.addObject("confesscompanyundo", confesscompanyundo);
            }
        }else{
            throw new ArsException("请先登录系统！");
        }
        return modelAndView;
    }

    /**
     * 编辑界面
     * @return
     */
    @RequestMapping("/applyEdit.do")
    public ModelAndView applyEdit(HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("confesscompanyundo/applyEdit");
        User user = arsUtil.getCurrentUser();
        if(user != null) {

            if(request.getParameter("businessid")!=null){
                Confesscompanyundo confesscompanyundo=confesscompanyundoService.findById(Long.parseLong(request.getParameter("businessid")));
                modelAndView.addObject("confesscompanyundo",confesscompanyundo);
                if(confesscompanyundo.getApproval() != null){
                    Config configVersion = configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);

                    if(  configVersion != null && !Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
                        modelAndView.addObject("approvalRev", "0");
                    }else{
                        modelAndView.addObject("approvalRev","1");
                    }
                }else{
                    modelAndView.addObject("approvalRev","1");
                }
            }
        }else{
            throw new ArsException("请先登录系统！");
        }
        return modelAndView;
    }

    /**
     * 详情界面
     * @return
     */
    @RequestMapping("/applyDetails.do")
    public ModelAndView applyDetails(HttpServletRequest request){
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("confesscompanyundo/appliyDetails");
        if(request.getParameter("businessid")!=null){
            Confesscompanyundo confesscompanyundo=confesscompanyundoService.findById(Long.parseLong(request.getParameter("businessid")));
            confesscompanyundo.setSzss(ajustSzss(confesscompanyundo));



            modelAndView.addObject("confesscompanyundo",confesscompanyundo);
        }
        return modelAndView;
    }

    private String ajustSzss(Confesscompanyundo confesscompanyundo) {
        //地址格式转换
        String s =confesscompanyundo.getSzss();


        if (s.contains("广西壮族自治区")||s.contains("内蒙古自治区")|| s.contains("西藏自治区")||  s.contains("宁夏回族自治区") ||  s.contains("新疆维吾尔自治区")) {
            s = s.substring(0, s.indexOf("区") + 1) + "/" + s.substring(s.indexOf("区") + 1, s.indexOf("市") + 1) + "/" + s.substring(s.indexOf("市") + 1, s.length());
        } else if (s.contains("香港特别行政区") || s.contains("澳门特别行政区")) {

        } else if(s.contains("省")) {
            if(s.contains("市")){
                s = s.substring(0, s.indexOf("省") + 1) + "/" + s.substring(s.indexOf("省") + 1, s.indexOf("市") + 1) + "/" + s.substring(s.indexOf("市") + 1, s.length());
                if (!s.contains("区")){
                    //陕西省/西安市//未央分局---》没有选择区的话会多一个斜杠，去除这个斜杠
                   s= s.substring(0,s.length() - 1);

                }
            }else{
                s = s.substring(0, s.indexOf("省") + 1) + "/" + s.substring(s.indexOf("省") + 1, s.indexOf("区") + 1) + "/" + s.substring(s.indexOf("区") + 1, s.length());
            }


        }
        if(confesscompanyundo.getPolice()!=null) {
            Police police = confesscompanyundo.getPolice();
            if (s.contains("广西壮族自治区")||s.contains("内蒙古自治区")|| s.contains("西藏自治区")||  s.contains("宁夏回族自治区") ||  s.contains("新疆维吾尔自治区")) {
                s=s+"/"+police.getOrgname();
            } else if (s.contains("香港特别行政区") || s.contains("澳门特别行政区")) {

            } else if(s.contains("省")) {
                s=s+"/"+police.getOrgname();
            }
        }

       return s;
    }

    /**
     * 查询界面
     * @return
     */
    @RequestMapping("/applyList.do")
    public ModelAndView applyList() {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("confesscompanyundo/applyList");
        return modelAndView;
    }

    /**
     * 搜索查询
     * @param params
     * @param model
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping("/searchConfesscompanyundoList_table")
    @RequiresPermissions("confesscompanyundo:query")
    @ResponseBody
    public PageResult searchConfesscompanyundoList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                         HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        return confesscompanyundoService.searchConfesscompanyundoList_table(p);//进行查询，并转换
    }

    @RequestMapping("list/index")
    public ModelAndView listIndex(ConfesscompanyundoSearchDto searchDto){
        ModelAndView view = new ModelAndView("confesscompanyundo/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("confesscompanyundo:query")
    @ResponseBody
    public AjaxPageResponse searchForPage(ConfesscompanyundoSearchDto dto, AjaxPageResponse<Confesscompanyundo> page){
        confesscompanyundoService.searchForPage(dto,page);
        return page;
    }

    /**
     * 根据ID获取单据明细
     * @return
     */
    @RequestMapping("/findById/{id}")
    @ResponseBody
    public AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Confesscompanyundo confesscompanyundo = confesscompanyundoService.findById(id);
            confesscompanyundo.setSzss(ajustSzss(confesscompanyundo));
            result.setSuccessful(true);
            result.setData(confesscompanyundo);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据当前登录用户获取未提交明细
     * @return
     */
    @RequestMapping("/findUNSubmitByUser")
    @ResponseBody
    public AjaxResult findUNSubmitByUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompanyundo confesscompanyundo = confesscompanyundoService.findUNSubmitByUser(user.getId());
                if(confesscompanyundo != null){
                    result.setSuccessful(true);
                    result.setData(confesscompanyundo);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 单据保存
     * @param confesscompanyundo
     * @return
     */
    @RequestMapping("/save")
    @ResponseBody
    public AjaxResult save(Confesscompanyundo confesscompanyundo){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                confesscompanyundoService.saveOrUpdate(confesscompanyundo);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 单据审批
     * @param businessid
     * @param approvalstate
     * @return
     */
    @RequestMapping("/approve")
    @ResponseBody
    public AjaxResult approve(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompanyundo confesscompanyundo = confesscompanyundoService.findById(businessid);
                if(confesscompanyundo != null){
                    confesscompanyundo.setApprovalstate(approvalstate);
                    confesscompanyundoService.approve(confesscompanyundo);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新审查结果
     * @param businessid
     * @param approvalstate
     * @return
     */
    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompanyundo confesscompanyundo = confesscompanyundoService.findById(businessid);
                if(confesscompanyundo != null){
                    confesscompanyundo.setCensorstatus(approvalstate);
                    confesscompanyundoService.updateCensorStatus(confesscompanyundo);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
