package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ConfesscompanySearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.SecurityTraincompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.SecurityTraincompanyService;
import com.bcxin.ars.service.sb.ConfesscompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("confesscompany")
public class ConfesscompanyController {

    private Logger logger = LoggerFactory.getLogger(ConfesscompanyController.class);
    @Autowired
    private ConfesscompanyService confesscompanyService;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private SecurityTraincompanyService securityTraincompanyService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SysDictUtils sysDictUtils;

    @Autowired
    private GXSSOUtil gxssoUtil;
    
    /**
     * 查询培训单位信息
     * @param dto
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AjaxResult findAll(ConfesscompanySearchDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            ConfesscompanySearchDto data = confesscompanyService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * @author wjb
     * @date 2018年8月16日17:57:46
     * @param type 编码类型
     * @return result
     * @desc 查询单位类型信息
     */
    @RequestMapping("getCompanytype/{type}")
    public @ResponseBody
    AjaxResult getCompanytype(@PathVariable(value ="type") String type) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
          List<Sysdict> sysdictList = sysDictUtils.getDictType(type);
          if(null!=sysdictList){
              result.setSuccessful(true);
              result.setData(sysdictList);
          }else{
              result.setSuccessful(false);
          }

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchConfesscompanyList_table")
    @RequiresPermissions("confesscompany:query")
    @ResponseBody
    public PageResult searchConfesscompanyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                     HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if (params.get("checkType")!=null) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (user.getPlatform() == 2) {
                    p.put("userid",user.getId());
                }else{
                    //角色列表
                    List<PoliceRole> roles = user.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        return confesscompanyService.searchConfesscompanyList_table(p);
    }










    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(SubsidiarySearchDto searchDto){
        ModelAndView view = new ModelAndView("confesscompany/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("confesscompany:query")
    public AjaxPageResponse searchForPage(ConfesscompanySearchDto dto, AjaxPageResponse<Confesscompany> page){
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        confesscompanyService.searchForPage(dto,page);
        return page;
    }







    @RequestMapping("search")
    public @ResponseBody AjaxResult search(ConfesscompanySearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	/*if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}*/
                result.setSuccessful(true);
                result.setData(confesscompanyService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Confesscompany confesscompany, HttpSession httpSession) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                if(user.getPlatform() == 1){
                    confesscompanyService.saveOrUpdateBypolice(confesscompany);
                }else{
                    confesscompanyService.saveOrUpdate(confesscompany);
                    String projectNo= (String) httpSession.getAttribute("projectNo");
                    if (StringUtil.isNotEmpty(projectNo)){
                        String token= (String) httpSession.getAttribute("gxssotoken");
                        gxssoUtil.reportData(token,projectNo);
                    }
                }

            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Confesscompany confesscompany = confesscompanyService.findById(id);
            result.setSuccessful(true);
            result.setData(confesscompany);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompany confesscompany = confesscompanyService.findByUser(user.getId());
                if(confesscompany != null){
                    result.setSuccessful(true);
                    result.setData(confesscompany);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompany confesscompany = confesscompanyService.findById(businessid);
                if(confesscompany != null){
                    confesscompany.setLegalcensorstatus(approvalstate);
                    confesscompanyService.updateCensorStatus(confesscompany);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("plan/updateApprovalResult")
    public @ResponseBody AjaxResult updatePlanApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Confesscompany  confesscompany = confesscompanyService.findById(businessid);
                if(confesscompany != null){
                    confesscompany.setChargecensorstatus(approvalstate);
                    confesscompanyService.updateCensorStatus(confesscompany);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 账号生成
     * @return
     */
    @RequestMapping("buildAccount/{id}")
    public @ResponseBody AjaxResult buildAccount(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Confesscompany confesscompany = confesscompanyService.findById(id);

            //源实体类的列，目标实体类的列
            String[] srccol = {"companyname","companytype","szss","district","province","city","legaladdress","recordarea","chargename","chargepost",
                    "chargecardnumber","chargephone","recordcompanyname"};
            String[] desccol = {"dwmc","dwlx","szss","district","province","city","szdz","fwlx","barxm","barzw","barsfzh","bardh","jgmc"};
            //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
            String[] key = {};
            String[] value = {};
            //生成实体
            Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,confesscompany,new SecurityTraincompany(),key,value);
            SecurityTraincompany securityTraincompany =(SecurityTraincompany)desc;
            securityTraincompany.setUserid(confesscompany.getUserid());
            securityTraincompanyService.saveOrUpdate(securityTraincompany);

            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 删除
     * @return
     */
    @RequestMapping("delete/{id}")
    public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Confesscompany confesscompany = confesscompanyService.findById(id);

            if(confesscompany != null) {
                confesscompanyService.delete(confesscompany);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("删除信息失败，ID:" + id);
            }

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
