package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.page.CerLearnAuthRecordPageSearchDto;
import com.bcxin.ars.model.sb.CerLearnAuthRecord;
import com.bcxin.ars.service.sb.CerLearnAuthRecordService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 资格证/等级证学习认证记录Controller
 * 
 * @author lin
 * @date 2020-09-08
 */
@Controller
@RequestMapping("/cerLearnAuthRecord")
public class CerLearnAuthRecordController {
    Logger logger = LoggerFactory.getLogger(CerLearnAuthRecordController.class);

    @Autowired
    private CerLearnAuthRecordService cerLearnAuthRecordService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CerLearnAuthRecordPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("cerLearnAuthRecord/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CerLearnAuthRecordPageSearchDto dto, AjaxPageResponse<CerLearnAuthRecord> page){
        cerLearnAuthRecordService.searchForPage(dto,page);
        return page;
    }

}
