package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.dto.sb.ArmtrainorgSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armtrainorg;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.service.sb.ArmtrainorgService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.CTLUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("armtrainorg")
public class ArmtrainorgController {

    private Logger logger = LoggerFactory.getLogger(ArmtrainorgController.class);
    @Autowired
    private ArmtrainorgService armtrainorgService;

    @Autowired
    private ArsUtil arsUtil;

    @RequestMapping("/searchArmtrainorgList_table")
    @RequiresPermissions("armtrainorg:query")
    @ResponseBody
    public Object searchArmtrainorgList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                               HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

        CTLUtil.out(armtrainorgService.searchArmtrainorgList_table(p), resp);//进行查询，并转换
        return null;
    }







    @RequestMapping("list/index")
    public ModelAndView listIndex(ArmtrainorgSearchDto searchDto){
        ModelAndView view = new ModelAndView("armtrainorg/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("armtrainorg:query")
    @ResponseBody
    public AjaxPageResponse searchForPage(ArmtrainorgSearchDto dto, AjaxPageResponse<Armtrainorg> page){

        armtrainorgService.searchForPage(dto,page);
        return page;
    }






    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Armtrainorg armtrainorg) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                armtrainorgService.saveOrUpdate(armtrainorg);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Armtrainorg armtrainorg = armtrainorgService.findById(id);
            result.setSuccessful(true);
            result.setData(armtrainorg);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Armtrainorg armtrainorg = armtrainorgService.findByUser(user.getId());
                if(armtrainorg != null){
                    result.setSuccessful(true);
                    result.setData(armtrainorg);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("search")
    public @ResponseBody AjaxResult search(ArmtrainorgSearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	/*if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}*/
                result.setSuccessful(true);
                result.setData(armtrainorgService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Armtrainorg armtrainorg = armtrainorgService.findById(businessid);
                if(armtrainorg != null){
                    armtrainorg.setLegalcensorstatus(approvalstate);
                    armtrainorgService.updateCensorStatus(armtrainorg);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
