package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ArmorgteachSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armorgteach;
import com.bcxin.ars.service.sb.ArmorgteachService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("armorgteach")
public class ArmorgteachController {

	Logger logger = LoggerFactory.getLogger(ArmorgteachController.class);
	
	@Autowired
	private ArmorgteachService armorgteachService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ArmorgteachSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				ArmorgteachSearchDto list = armorgteachService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Armorgteach armorgteach) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				armorgteachService.saveOrUpdate(armorgteach);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Armorgteach armorgteach = armorgteachService.findById(id);
			result.setSuccessful(true);
			result.setData(armorgteach);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Armorgteach armorgteach = armorgteachService.findById(businessid);
                if(armorgteach != null){
                	armorgteach.setCensorstatus(approvalstate);
					armorgteachService.updateCensorStatus(armorgteach);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
