package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.ApproveAttachmentPageSearchDto;
import com.bcxin.ars.model.sb.ApproveAttachment;
import com.bcxin.ars.service.sb.ApproveAttachmentService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;


/**
 * 审批补充材料Controller
 * 
 * @author lin
 * @date 2021-05-06
 */
@Controller
@RequestMapping("/approveAttachment")
public class ApproveAttachmentController{
    Logger logger = LoggerFactory.getLogger(ApproveAttachmentController.class);

    @Autowired
    private ApproveAttachmentService approveAttachmentService;

    @Autowired
    private ConfigUtils configUtils;


    private static final String RELATIVE_ATTACHMENT_PATH = "approveAttachment";

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(ApproveAttachmentPageSearchDto dto, AjaxPageResponse<ApproveAttachment> page){
        approveAttachmentService.searchForPage(dto,page);
        return page;
    }


    /**
     * 上传文件
     * @param file
     * @return
     */
    @RequestMapping("uploadFile")
    public @ResponseBody AjaxResult uploadFile(MultipartFile file,ApproveAttachment approveAttachment) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();

            String baseAttachmentFolder = configUtils.baseFolder + RELATIVE_ATTACHMENT_PATH + "/";

            String originalFilename = file.getOriginalFilename();
            String uploadFileName = originalFilename.substring(0,originalFilename.lastIndexOf(".")); //文件名
            String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1); //文件类型
            String fileName = FileUtil.createFileName(materialFileType);
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(baseAttachmentFolder + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = RELATIVE_ATTACHMENT_PATH + File.separatorChar +dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseAttachmentFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行本地文件上传..." + targetFile);
            file.transferTo(targetFile);

            approveAttachment.setPath(url);
            approveAttachment.setFileName(uploadFileName+"."+materialFileType);
            approveAttachment.setFileSize(file.getSize());
            approveAttachmentService.save(approveAttachment);
            logger.info("本地文件上传成功!");
            result.setSuccessful(true);
            result.setData(approveAttachment);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 下载
     * @param id
     * @param request
     * @param response
     * @throws Exception
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @RequestMapping(value = "/download.do")
    public void downloadAction(Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApproveAttachment sysAttachment = approveAttachmentService.findById(id);
        String fileName = sysAttachment.getFileName();
        String path = sysAttachment.getPath();
        if(path.indexOf(RELATIVE_ATTACHMENT_PATH)>0) {
            path = configUtils.baseFolder + sysAttachment.getPath().replace("getResource.do?path=", "");
        }
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName,"UTF-8"));
        BufferedInputStream br = new BufferedInputStream(new FileInputStream(path));
        byte[] buf = new byte[1024];
        int len = 0;
        OutputStream out = response.getOutputStream();
        while ((len = br.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        br.close();
        out.close();
    }

    /**
     * 删除
     * @param approveAttachment
     * @return
     */
    @RequestMapping("remove")
    @ResponseBody
    public AjaxResult remove(ApproveAttachment approveAttachment){
        AjaxResult result = new AjaxResult();
        try {
            approveAttachment.setActive(false);
            approveAttachmentService.updateSelective(approveAttachment);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
