package com.bcxin.ars.rest.report;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.report.*;
import com.bcxin.ars.service.report.*;
import com.bcxin.ars.service.statistics.PoliceNoticeStatisticsService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2019/11/30 0030 13:58
 */
@RequestMapping("report")
@Controller
public class ReportController {

    @Autowired
    private ReportProblemPersonService reportProblemPersonService;

    @Autowired
    private ReportPersoncertificateService reportPersoncertificateService;

    @Autowired
    private ReportPersonService reportPersonService;

    @Autowired
    private ReportCompanyService reportCompanyService;

    @Autowired
    private ReportTaskService reportTaskService;

    @Autowired
    private ReportTrainService reportTrainService;

    @Autowired
    private PoliceNoticeStatisticsService policeNoticeStatisticsService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @RequestMapping("/dashboard")
    public ModelAndView dashboard(@RequestParam Map<Object, Object> params, SearchDto searchDto, HttpServletRequest req) {
        ModelAndView view = new ModelAndView("report/dashboard");

        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        //处长角色id
        p.put("czjsid",req.getServletContext().getAttribute("czjsid"));
        p.put("searchType","001");
        //打印的保安员证角色id
        req.getServletContext().getAttribute("printPersonCardRole");
        view.addObject("content",policeNoticeStatisticsService.getPoliceNotice(p));

        if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
            //北京网
            getReportData(searchDto,view);

            view.addObject("yesterDay", DateUtil.getYesterday());
        }

        return view;
    }

    private void getReportData(SearchDto searchDto,ModelAndView view){
        searchDto.setPoliceBusiness(false);
        arsUtil.setPoliceSearch(searchDto);
        List<ReportProblemPerson> problemPersonList = reportProblemPersonService.findReport(searchDto);
        List<ReportPersoncertificate> personcertificateList = reportPersoncertificateService.findReport(searchDto);
        List<ReportPersoncertificate> personcertificateLastList = reportPersoncertificateService.findLastYearReport(searchDto);
        List<ReportPerson> personList = reportPersonService.findReport(searchDto);
        List<ReportCompany> companyList = reportCompanyService.findReport(searchDto);
        List<ReportTask> taskList = reportTaskService.findReport(searchDto);
        //List<ReportTrain> trainList = reportTrainService.findReport(searchDto);

        Map<String, ReportProblemPerson> problemPersonMap = problemPersonList.stream().collect(Collectors.toMap(ReportProblemPerson::getDateType, Function.identity()));
        Map<String, ReportPersoncertificate> personcertificateMap = personcertificateList.stream().collect(Collectors.toMap(ReportPersoncertificate::getDateType, Function.identity()));
        Map<String, ReportPersoncertificate> personcertificateLastMap = personcertificateLastList.stream().collect(Collectors.toMap(ReportPersoncertificate::getDateType, Function.identity()));
        ReportPersoncertificate year = personcertificateMap.get("1");
        ReportPersoncertificate month = personcertificateMap.get("2");
        ReportPersoncertificate week = personcertificateMap.get("3");
        ReportPersoncertificate yearLast = personcertificateLastMap.get("1");
        ReportPersoncertificate monthLast = personcertificateLastMap.get("2");
        ReportPersoncertificate weekLast = personcertificateLastMap.get("3");

        week.setRate((float)(Math.round((week.getPassRate()-weekLast.getPassRate())*100)/100));
        month.setRate((float)(Math.round((month.getPassRate()-monthLast.getPassRate())*100)/100));
        year.setRate((float)(Math.round((year.getPassRate()-yearLast.getPassRate())*100)/100));
        personcertificateMap.put("1",year);
        personcertificateMap.put("2",month);
        personcertificateMap.put("3",week);

        Map<String, ReportTask> taskMap = taskList.stream().collect(Collectors.toMap(ReportTask::getDateType, Function.identity()));
        //Map<String, ReportTrain> trainMap = trainList.stream().collect(Collectors.toMap(ReportTrain::getDateType, Function.identity()));
        Map<String, ReportPerson> personMap = personList.stream().collect(Collectors.toMap(ReportPerson::getInstitutionType, Function.identity()));
        Map<String, ReportCompany> companyMap = companyList.stream().collect(Collectors.toMap(ReportCompany::getInstitutionType, Function.identity()));

        view.addObject("problemPersonMap",problemPersonMap);
        view.addObject("personcertificateMap",personcertificateMap);
        view.addObject("taskMap",taskMap);
        //view.addObject("trainMap",trainMap);

        view.addObject("companyMap",companyMap);
        view.addObject("personMap",personMap);

    }
}
