package com.bcxin.ars.rest.old;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.old.Zxzybaydwjbxx;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.old.ZxzybaydwjbxxService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 旧自招单位
 * @author linqinglin
 * @date 2019/10/29 0029 13:54
 */
@Controller
@RequestMapping("old/confesscompany")
public class ZxzybaydwjbxxController {

    private Logger logger = LoggerFactory.getLogger(ZxzybaydwjbxxController.class);

    @Autowired
    private ZxzybaydwjbxxService zxzybaydwjbxxService;

    @Autowired
    private SecurityCompanyService companyService;

    @Autowired
    private UserService userService;

    @Autowired
    private ArsUtil arsUtil;

    /**
     * 自招单位 信息管理 页面进入
     * @return
     */
    @RequestMapping("list/index")
    public String listIndex() {
        return "old/confesscompany/list";
    }


    /**
     * 自招单位 信息管理 列表查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(Zxzybaydwjbxx dto, AjaxPageResponse page){
        try {
            zxzybaydwjbxxService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 自招单位 详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detail")
    public ModelAndView detail(Long id){
        ModelAndView view = new ModelAndView("old/confesscompany/detail");
        try {
            view.addObject("content",zxzybaydwjbxxService.findById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }

    /**
     * 自招单位 修改 页面进入
     * @param id
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView edit(Long id){
        ModelAndView view = new ModelAndView("old/confesscompany/edit");
        try {
            view.addObject("content",zxzybaydwjbxxService.findById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }

    /**
     * 自招单位 保存
     * @param zxzybaydwjbxx
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(Zxzybaydwjbxx zxzybaydwjbxx){
        AjaxResult result = new AjaxResult();
        try {
            zxzybaydwjbxxService.save(zxzybaydwjbxx);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 自招单位 生成账号
     * @param id
     * @return
     */
    @RequestMapping("createAccount")
    @ResponseBody
    public AjaxResult createAccount(Long id){
        AjaxResult result = new AjaxResult();
        try {
            Zxzybaydwjbxx oldCompany = zxzybaydwjbxxService.findById(id);

            if(StringUtil.isEmpty(oldCompany.getDwmc())){
                throw new ArsException("单位名称不能为空,请修改后再重新生成账号");
            }

            if(StringUtil.isEmpty(oldCompany.getFddbrxm())){
                throw new ArsException("法人姓名不能为空,请修改后再重新生成账号");
            }

            if(StringUtil.isEmpty(oldCompany.getFddbrlxdh())){
                throw new ArsException("法人联系电话不能为空,请修改后再重新生成账号");
            }else{
                String phone = oldCompany.getFddbrlxdh();
                String regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
                Pattern p = Pattern.compile(regex);
                 Matcher m = p.matcher(phone);
                boolean isMatch = m.matches();
                if(phone.length() != 11 || !isMatch){
                    throw new ArsException("法人联系电话(手机)格式错误,请修改后再重新生成账号");
                }
            }

            Police police = arsUtil.getCurrentUser().getPolice();

            SecurityCompany company = new SecurityCompany();
            company.setLocal(true);
            company.setName(oldCompany.getDwmc());
            company.setLegalPerson(oldCompany.getFddbrxm());
            company.setInstitutionType(Constants.INSTITUTIONTYPE_ZXZY);
            company.setAreaCode(police.getAreacode());
            User user = new User();
            user.setPlatform(Constants.PLATFORM_COMPANY);
            user.setUsername(oldCompany.getFddbrlxdh());
            user.setPhone(oldCompany.getFddbrlxdh());
            user.setRealname(oldCompany.getDwmc());
            userService.saveOrUpdateCompanyUser(user,String.valueOf(Constants.PLATFORM_COMPANY));
            company.setUser(user);
            companyService.saveOrUpdate(company);

            oldCompany.setComId(company.getId()+"");

            zxzybaydwjbxxService.save(oldCompany);
            result.setSuccessful(true);

        } catch (Exception e) {
            throw e;
        }
        return result;
    }
}
