package com.bcxin.ars.rest.old;


import com.bcxin.ars.model.old.Bayjbxx;
import com.bcxin.ars.service.old.BayjbxxService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 保安员信息
 * @author subh
 */
@Controller
@RequestMapping("old/bay")
public class BayjbxxController {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(BafwjbxxController.class);
    /***
     * 保安员信息
     */
    @Autowired
    private BayjbxxService baBayjbxxService;

    /**
     * 旧保安员信息管理 页面进入
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(String institutionType,String newSystem,String zlzzt) {
         ModelAndView view = new ModelAndView("old/person/list");
        view.addObject("institutionType",institutionType);
        view.addObject("newSystem",newSystem);
        view.addObject("zlzzt",zlzzt);
        return view;
    }
    /**
     * 旧保安员信息管理 列表查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(Bayjbxx dto, AjaxPageResponse page){
        try {
            baBayjbxxService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    /**
     * 旧保安员信息详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detail")
    public ModelAndView detail(String id){
        ModelAndView view = new ModelAndView("old/person/detail");
        try {
            Bayjbxx record =  baBayjbxxService.findById(id);
            view.addObject("record",record);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }
}
