package com.bcxin.ars.rest.old;

import com.bcxin.ars.model.old.Bafwjbxx;
import com.bcxin.ars.service.old.BafwjbxxService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 旧驻勤点合同
 * @author linqinglin
 * @date 2019/10/29 0029 13:54
 */
@Controller
@RequestMapping("old/taskContract")
public class BafwjbxxController {

    private Logger logger = LoggerFactory.getLogger(BafwjbxxController.class);

    @Autowired
    private BafwjbxxService baBafwjbxxService;

    /**
     * 驻勤点信息管理 页面进入
     * @return
     */
    @RequestMapping("list/index")
    public String listIndex() {
        return "old/task/list";
    }


    /**
     * 驻勤点信息管理 列表查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(Bafwjbxx dto, AjaxPageResponse page){
        try {
            baBafwjbxxService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 驻勤点详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detail")
    public ModelAndView detail(String id){
        ModelAndView view = new ModelAndView("old/task/detail");
        try {
            view.addObject("content",baBafwjbxxService.findById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }
}
