package com.bcxin.ars.rest.nxWeb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.rest.gxhlwWeb.GxhlwWebController;
import com.bcxin.ars.service.nxWeb.NXWebService;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
@Controller
@RequestMapping("nxWeb")
public class NxWebController {



    private static final Logger logger = LoggerFactory.getLogger(GxhlwWebController.class);

    @Autowired
    private NXWebService nxWebService;

    /**
     * @Author: wangcy
     * @Description:根据用户名和密码获取用户信息
     * @Date: 2018/03/22 0022 13:39
     */
    @RequestMapping("login")
    public String searchForMap(String username, String key, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = request.getServletContext();
        String rootPath = servletContext.getContextPath();
        try {
            //登录成功
            if (StringUtil.isNotEmpty(username) && StringUtil.isNotEmpty(key)) {
                AjaxResult ajaxResult = nxWebService.verifySX(username, key, request);
                if (ajaxResult.isSuccessful()) {
                    return "redirect:/index.do";
                }else{
                    response.sendRedirect(rootPath+"/login.jsp");
                }
            } else {
                response.sendRedirect(rootPath+"/login.jsp");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return "error";
    }
}
